/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.hud;

import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.hud.SingleTextHud;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.TextRenderer;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import java.awt.Color;
import org.polyfrost.vanillahud.VanillaHUD;
import org.polyfrost.vanillahud.config.HudConfig;
import org.polyfrost.vanillahud.mixin.minecraft.GuiIngameAccessor;
import org.polyfrost.vanillahud.mixin.minecraft.MinecraftAccessor;

public class ActionBar
extends HudConfig {
    @HUD(name="Action Bar")
    public ActionBarHUD hud = new ActionBarHUD();

    public ActionBar() {
        super("Action Bar", "actionbar.json");
        this.initialize();
    }

    public static class ActionBarHUD
    extends SingleTextHud {
        @Exclude
        private float hue;
        @Exclude
        private int opacity;
        @Exclude
        private static final String EXAMPLE_TEXT = "Action Bar";
        @Switch(name="Use Jukebox Rainbow Timer Color", description="Use the rainbow timer color when a jukebox begins playing.")
        private boolean rainbowTimer = true;

        public ActionBarHUD() {
            super("", true, 960.0f, 1018.0f, 1.0f, false, false, 0.0f, 0.0f, 0.0f, new OneColor(0, 0, 0, 80), false, 2.0f, new OneColor(0, 0, 0));
            EventManager.INSTANCE.register((Object)this);
            this.showInDebug = true;
        }

        protected void drawLine(String line, float x, float y, float scale) {
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)UMinecraft.getMinecraft().field_71456_v;
            int color = this.rainbowTimer && ingameGUI.getRecordIsPlaying() ? Color.HSBtoRGB(this.hue / 50.0f, 0.7f, 0.6f) & 0xFFFFFF : ColorUtils.setAlpha((int)this.color.getRGB(), (int)Math.min(this.color.getAlpha(), this.opacity));
            UGraphics.enableBlend();
            TextRenderer.drawScaledString((String)line, (float)x, (float)y, (int)(color | this.opacity << 24), (TextRenderer.TextType)TextRenderer.TextType.toType((int)this.textType), (float)scale);
        }

        protected boolean shouldShow() {
            if (VanillaHUD.isApec()) {
                return false;
            }
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)UMinecraft.getMinecraft().field_71456_v;
            if (ingameGUI.getRecordPlayingUpFor() <= 0 || ingameGUI.getRecordPlaying() == null || ingameGUI.getRecordPlaying().isEmpty()) {
                return false;
            }
            this.hue = (float)ingameGUI.getRecordPlayingUpFor() - ((MinecraftAccessor)UMinecraft.getMinecraft()).getTimer().field_74281_c;
            this.opacity = (int)(this.hue * 256.0f / 20.0f);
            if (this.opacity > 255) {
                this.opacity = 255;
            }
            return this.opacity > 0 && super.shouldShow();
        }

        protected void drawBackground(float x, float y, float width, float height, float scale) {
            NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
            nanoVGHelper.setupAndDraw(true, vg -> {
                int bgColor = ColorUtils.setAlpha((int)this.bgColor.getRGB(), (int)Math.min(this.bgColor.getAlpha(), this.opacity));
                int borderColor = ColorUtils.setAlpha((int)this.borderColor.getRGB(), (int)Math.min(this.borderColor.getAlpha(), this.opacity));
                if (this.rounded) {
                    nanoVGHelper.drawRoundedRect(vg, x, y, width, height, bgColor, this.cornerRadius * scale);
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, borderColor, this.cornerRadius * scale, this.borderSize * scale);
                    }
                } else {
                    nanoVGHelper.drawRect(vg, x, y, width, height, bgColor);
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, borderColor, 0.0f, this.borderSize * scale);
                    }
                }
            });
        }

        protected String getText(boolean example) {
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)UMinecraft.getMinecraft().field_71456_v;
            if (ingameGUI == null || ingameGUI.getRecordPlaying() == null || ingameGUI.getRecordPlaying().isEmpty() || !this.shouldShow() && example) {
                this.opacity = 255;
                return EXAMPLE_TEXT;
            }
            return ingameGUI.getRecordPlaying();
        }

        public void setTextType(int textType) {
            this.textType = textType;
        }

        public void setBackground(boolean background) {
            this.background = background;
        }
    }
}

