/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.hud;

import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Slider;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.hud.SingleTextHud;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.boss.BossStatus;
import org.polyfrost.vanillahud.config.HudConfig;
import org.polyfrost.vanillahud.hooks.BossStatusHook;

public class BossBar
extends HudConfig {
    @HUD(name="Boss Bar")
    public static BossBarHUD hud = new BossBarHUD();

    public BossBar() {
        super("Boss Bar", "bossbar.json");
        this.initialize();
    }

    public static class BossBarHUD
    extends SingleTextHud {
        @Switch(name="Render Text")
        public boolean renderText = true;
        @Switch(name="Render Health")
        public boolean renderHealth = true;
        @Switch(name="Smooth Health", description="Lerps the health bar to make it smoother. Similar to the boss bar progress in modern versions of Minecraft.")
        public boolean smoothHealth = true;
        @Slider(name="Lerp Speed", min=1.0f, max=1000.0f)
        public float lerpSpeed = 100.0f;
        @Slider(name="Bar Position", min=0.0f, max=100.0f)
        public float barPosition = 50.0f;
        @Exclude
        public static final Minecraft mc = UMinecraft.getMinecraft();
        @Exclude
        public static final FontRenderer fontRenderer = UMinecraft.getFontRenderer();
        @Exclude
        public static final int BAR_WIDTH = 182;

        public BossBarHUD() {
            super("", true, 960.0f, 2.0f, 1.0f, false, false, 0.0f, 0.0f, 0.0f, new OneColor(0, 0, 0, 120), false, 2.0f, new OneColor(0, 0, 0));
            this.textType = 1;
            this.showInDebug = true;
            EventManager.INSTANCE.register((Object)this);
        }

        protected String getText(boolean example) {
            return this.getTextFrequent(example);
        }

        protected String getTextFrequent(boolean example) {
            return this.isBossActive() ? BossStatus.field_82827_c : "Wither";
        }

        public void draw(UMatrixStack matrices, float x, float y, float scale, boolean example) {
            UGraphics.GL.pushMatrix();
            UGraphics.GL.scale((float)scale, (float)scale, (float)1.0f);
            UGraphics.GL.translate((float)(x / scale), (float)(y / scale), (float)1.0f);
            this.drawHealth(this.getCompleteText(this.getText(example)), this.isBossActive() ? (this.smoothHealth ? BossStatusHook.getPercent() : BossStatus.field_82828_a) : 0.8f, 0.0f, this.renderText ? 10.0f : 0.0f);
            if (this.renderText) {
                super.draw(matrices, this.getWidth(1.0f, example) / 2.0f - (float)(fontRenderer.func_78256_a(this.getCompleteText(this.getText(example))) / 2), 0.0f, 1.0f, example);
            }
            UGraphics.GL.popMatrix();
        }

        protected boolean shouldShow() {
            return this.drawingBossBar();
        }

        public boolean drawingBossBar() {
            return this.isBossActive() && super.shouldShow();
        }

        private boolean isBossActive() {
            return BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0;
        }

        public void drawHealth(String bossName, float healthScale, float x, float y) {
            if (this.isBossActive()) {
                --BossStatus.field_82826_b;
            }
            UGraphics.enableBlend();
            UGraphics.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            if (this.renderText && fontRenderer.func_78256_a(bossName) > 182) {
                x += (float)(fontRenderer.func_78256_a(bossName) - 182) * this.barPosition / 100.0f;
            }
            float remainingHealth = healthScale * 182.0f;
            if (this.renderHealth) {
                BossBarHUD.mc.field_71456_v.func_175174_a(x, y, 0, 74, 182, 5);
                BossBarHUD.mc.field_71456_v.func_175174_a(x, y, 0, 74, 182, 5);
                if (remainingHealth > 0.0f) {
                    BossBarHUD.mc.field_71456_v.func_175174_a(x, y, 0, 79, (int)remainingHealth, 5);
                }
            }
        }

        protected float getWidth(float scale, boolean example) {
            float textWidth;
            float f = textWidth = this.renderText ? (float)UMinecraft.getFontRenderer().func_78256_a(this.getCompleteText(this.getText(example))) : 0.0f;
            float healthWidth = this.renderHealth ? 182.0f : 0.0f;
            return Math.max(textWidth, healthWidth) * scale;
        }

        protected float getHeight(float scale, boolean example) {
            float height = 0.0f;
            if (this.renderHealth) {
                height += 5.0f;
            }
            if (this.renderText) {
                height += 9.0f;
            }
            if (this.renderText && this.renderHealth) {
                height += 1.0f;
            }
            return height * scale;
        }
    }
}

