/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.hud;

import cc.polyfrost.oneconfig.config.annotations.DualOption;
import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.hud.Hud;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.GuiIngameForge;
import org.polyfrost.vanillahud.config.HudConfig;
import org.polyfrost.vanillahud.mixin.minecraft.GuiSpectatorAccessor;

public class Hotbar
extends HudConfig {
    @HUD(name="HotBar")
    public static HotBarHud hud = new HotBarHud();

    public Hotbar() {
        super("HotBar", "vanilla-hud/hotbar.json");
        this.initialize();
    }

    public static class HotBarHud
    extends Hud {
        @Exclude
        private static final Minecraft mc = Minecraft.func_71410_x();
        @DualOption(name="Mode", left="Vertical", right="Horizontal")
        public static boolean hotbarMode = true;
        @Switch(name="Animation")
        public static boolean animation = true;

        public HotBarHud() {
            super(true, 869.0f, 1058.0f);
            this.showInDebug = true;
        }

        public boolean isEnabled() {
            boolean isEnable = super.isEnabled();
            GuiIngameForge.renderHotbar = isEnable && this.shouldShow();
            return isEnable;
        }

        protected void draw(UMatrixStack matrices, float x, float y, float scale, boolean example) {
            GuiIngameForge.renderHotbar = this.shouldShow();
        }

        protected float getWidth(float scale, boolean example) {
            return (float)(hotbarMode ? 182 : 22) * scale;
        }

        protected float getHeight(float scale, boolean example) {
            return (float)(hotbarMode ? 22 : 182) * scale;
        }

        protected boolean shouldShow() {
            if (HotBarHud.mc.field_71439_g == null || HotBarHud.mc.field_71456_v == null) {
                return false;
            }
            GuiSpectatorAccessor accessor = (GuiSpectatorAccessor)HotBarHud.mc.field_71456_v.func_175187_g();
            return super.shouldShow() && (!HotBarHud.mc.field_71439_g.func_175149_v() || accessor.alpha() > 0.0f);
        }
    }
}

