/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.hud;

import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.hud.SingleTextHud;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.spectator.ISpectatorMenuObject;
import net.minecraft.client.gui.spectator.SpectatorMenu;
import net.minecraft.util.EnumChatFormatting;
import org.polyfrost.vanillahud.VanillaHUD;
import org.polyfrost.vanillahud.config.HudConfig;
import org.polyfrost.vanillahud.mixin.minecraft.GuiIngameAccessor;
import org.polyfrost.vanillahud.mixin.minecraft.GuiSpectatorAccessor;

public class ItemTooltip
extends HudConfig {
    @HUD(name="Held Item Tooltip")
    public HeldItemTooltipHUD hud = new HeldItemTooltipHUD();

    public ItemTooltip() {
        super("Held Item Tooltip", "itemtooltip.json");
        this.initialize();
    }

    public static class HeldItemTooltipHUD
    extends SingleTextHud {
        @Switch(name="Fade Out")
        private static boolean fadeOut = true;
        @Switch(name="Instant Fade")
        private static boolean instantFade = false;
        @Exclude
        private int opacity;
        @Exclude
        private static String specText;
        @Exclude
        private static final String EXAMPLE_TEXT = "Item Tooltip";
        @Exclude
        private static final Minecraft mc;

        public HeldItemTooltipHUD() {
            super("", true, 960.0f, 1043.0f, 1.0f, false, false, 0.0f, 0.0f, 0.0f, new OneColor(0, 0, 0, 80), false, 2.0f, new OneColor(0, 0, 0));
            this.textType = 1;
            this.showInDebug = true;
            EventManager.INSTANCE.register((Object)this);
        }

        protected void drawLine(String line, float x, float y, float scale) {
            OneColor color = new OneColor(ColorUtils.setAlpha((int)this.color.getRGB(), (int)Math.min(this.color.getAlpha(), this.opacity)) | this.opacity << 24);
            UGraphics.enableBlend();
            super.drawLine(line, x, y, color, scale);
        }

        protected void drawLine(String line, float x, float y, OneColor c, float scale) {
            OneColor color = new OneColor(ColorUtils.setAlpha((int)c.getRGB(), (int)Math.min(c.getAlpha(), this.opacity)) | this.opacity << 24);
            UGraphics.enableBlend();
            super.drawLine(line, x, y, color, scale);
        }

        public void drawAll(UMatrixStack matrices, boolean example) {
            if (example) {
                this.opacity = 255;
            }
            super.drawAll(matrices, example);
        }

        protected boolean shouldShow() {
            GuiSpectatorAccessor spectatorAccessor;
            int i;
            int o;
            if (VanillaHUD.isApec()) {
                return false;
            }
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)HeldItemTooltipHUD.mc.field_71456_v;
            int n = o = fadeOut ? (int)((float)ingameGUI.getRemainingHighlightTicks() * 256.0f / 10.0f) : 255;
            if (o > 255) {
                o = 255;
            }
            this.opacity = instantFade ? 255 : o;
            String spectatorText = null;
            if (HeldItemTooltipHUD.mc.field_71439_g != null && HeldItemTooltipHUD.mc.field_71439_g.func_175149_v() && (i = (int)((spectatorAccessor = (GuiSpectatorAccessor)HeldItemTooltipHUD.mc.field_71456_v.func_175187_g()).alpha() * 255.0f)) > 3 && spectatorAccessor.getField_175271_i() != null) {
                ISpectatorMenuObject iSpectatorMenuObject = spectatorAccessor.getField_175271_i().func_178645_b();
                String string = spectatorText = iSpectatorMenuObject != SpectatorMenu.field_178657_a ? iSpectatorMenuObject.func_178664_z_().func_150254_d() : spectatorAccessor.getField_175271_i().func_178650_c().func_178670_b().func_150254_d();
                if (spectatorText != null) {
                    specText = spectatorText;
                    this.opacity = instantFade ? 255 : i;
                }
            }
            return (o > 0 || spectatorText != null) && super.shouldShow();
        }

        protected void drawBackground(float x, float y, float width, float height, float scale) {
            NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
            nanoVGHelper.setupAndDraw(true, vg -> {
                int bgColor = ColorUtils.setAlpha((int)this.bgColor.getRGB(), (int)Math.min(this.bgColor.getAlpha(), this.opacity));
                int borderColor = ColorUtils.setAlpha((int)this.borderColor.getRGB(), (int)Math.min(this.borderColor.getAlpha(), this.opacity));
                if (this.rounded) {
                    nanoVGHelper.drawRoundedRect(vg, x, y, width, height, bgColor, this.cornerRadius * scale);
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, borderColor, this.cornerRadius * scale, this.borderSize * scale);
                    }
                } else {
                    nanoVGHelper.drawRect(vg, x, y, width, height, bgColor);
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, borderColor, 0.0f, this.borderSize * scale);
                    }
                }
            });
        }

        protected String getText(boolean example) {
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)HeldItemTooltipHUD.mc.field_71456_v;
            if (example) {
                return EXAMPLE_TEXT;
            }
            if (HeldItemTooltipHUD.mc.field_71439_g != null && HeldItemTooltipHUD.mc.field_71439_g.func_175149_v()) {
                GuiSpectatorAccessor spectatorAccessor = (GuiSpectatorAccessor)HeldItemTooltipHUD.mc.field_71456_v.func_175187_g();
                int i = (int)(spectatorAccessor.alpha() * 255.0f);
                if (i > 3 && spectatorAccessor.getField_175271_i() != null) {
                    return specText;
                }
            } else if (!(ingameGUI.getRemainingHighlightTicks() <= 0 && fadeOut || ingameGUI.getHighlightingItemStack() == null)) {
                String string = ingameGUI.getHighlightingItemStack().func_82833_r();
                if (ingameGUI.getHighlightingItemStack().func_82837_s()) {
                    string = EnumChatFormatting.ITALIC + string;
                }
                return string;
            }
            return "";
        }

        static {
            mc = UMinecraft.getMinecraft();
        }
    }
}

