/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.hud;

import cc.polyfrost.oneconfig.config.annotations.Color;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.hud.BasicHud;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.TextRenderer;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.scoreboard.IScoreObjectiveCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import org.polyfrost.vanillahud.VanillaHUD;
import org.polyfrost.vanillahud.config.HudConfig;
import org.polyfrost.vanillahud.hooks.ScoreboardHook;

public class Scoreboard
extends HudConfig {
    @HUD(name="Scoreboard")
    public ScoreboardHUD hud = new ScoreboardHUD();

    public Scoreboard() {
        super("Scoreboard", "scoreboard.json");
        this.initialize();
    }

    public static class ScoreboardHUD
    extends BasicHud {
        @Dropdown(name="Show Score Points", category="Score Points", options={"Hide", "Hide Only if Consecutive", "Show Always"})
        public static int scoreboardPoints = 1;
        @Color(name="Score Points Color")
        public OneColor scorePointsColor = new OneColor(255, 85, 85);
        @Switch(name="Scoreboard Title")
        public static boolean scoreboardTitle = true;
        @Switch(name="Persistent Scoreboard Title")
        public boolean persistentTitle = false;
        @Color(name="Title Background Color")
        public OneColor titleColor = new OneColor(0, 0, 0, 96);
        @Dropdown(name="Text Type", options={"No Shadow", "Shadow", "Full Shadow"})
        public int textType = 0;
        @Exclude
        private static final Minecraft mc = UMinecraft.getMinecraft();
        @Exclude
        public static final FontRenderer fontRenderer = UMinecraft.getFontRenderer();
        @Exclude
        public float width = 0.0f;
        @Exclude
        public float height = 0.0f;

        public ScoreboardHUD() {
            super(true, 1919.0f, 540.0f, 1.0f, true, false, 0.0f, 1.0f, 0.0f, new OneColor(0, 0, 0, 80), false, 2.0f, new OneColor(0, 0, 0));
            EventManager.INSTANCE.register((Object)this);
            this.showInDebug = true;
        }

        public void draw(UMatrixStack matrices, float x, float y, float scale, boolean example) {
            UGraphics.GL.pushMatrix();
            UGraphics.GL.scale((float)scale, (float)scale, (float)1.0f);
            UGraphics.GL.translate((float)(x / scale), (float)(y / scale), (float)1.0f);
            ScoreObjective objective = ScoreboardHUD.mc.field_71441_e.func_96441_U().func_96539_a(1);
            if (!this.shouldShow()) {
                if (example) {
                    net.minecraft.scoreboard.Scoreboard scoreboard = new net.minecraft.scoreboard.Scoreboard();
                    objective = new ScoreObjective(scoreboard, "OneConfig", IScoreObjectiveCriteria.field_96641_b);
                    objective.func_96681_a(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Scoreboard");
                    scoreboard.func_96529_a("Drag me around!", objective);
                    scoreboard.func_96529_a("Click to drag", objective);
                } else {
                    return;
                }
            }
            this.renderObjective(objective);
            UGraphics.GL.popMatrix();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean shouldShow() {
            if (VanillaHUD.isApec()) return false;
            if (!ScoreboardHook.canDraw) return false;
            if (VanillaHUD.isSkyHanniScoreboard()) return false;
            if (ScoreboardHUD.mc.field_71441_e == null) {
                return false;
            }
            ScoreObjective objective = ScoreboardHUD.mc.field_71441_e.func_96441_U().func_96539_a(1);
            if (objective == null) return false;
            boolean bl = true;
            boolean showRealScoreboard = bl;
            if (showRealScoreboard) {
                Collection sortedScores = objective.func_96682_a().func_96534_i(objective);
                if (sortedScores.size() > 15) return false;
                if (sortedScores.size() <= 0) {
                    if (!this.persistentTitle) return false;
                    if (!scoreboardTitle) return false;
                }
                boolean bl2 = true;
                showRealScoreboard = bl2;
            }
            if (!showRealScoreboard) return false;
            if (!super.shouldShow()) return false;
            return true;
        }

        /*
         * Unable to fully structure code
         */
        private void renderObjective(ScoreObjective scoreObjective) {
            UGraphics.enableBlend();
            scoreboard = scoreObjective.func_96682_a();
            sortedScores = scoreboard.func_96534_i(scoreObjective);
            if (ScoreboardHUD.scoreboardPoints == 2) ** GOTO lbl-1000
            if (ScoreboardHUD.scoreboardPoints == 1 && this.isNonConsecutive(scoreObjective)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            showScorePoints = v0;
            displayName = scoreObjective.func_96678_d();
            displayNameStringWidth = ScoreboardHUD.fontRenderer.func_78256_a(displayName);
            for (Score score : sortedScores) {
                team = scoreboard.func_96509_i(score.func_96653_e());
                totalString = ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e()) + (showScorePoints != false ? ": " + EnumChatFormatting.RED + score.func_96652_c() : "");
                displayNameStringWidth = Math.max(displayNameStringWidth, ScoreboardHUD.fontRenderer.func_78256_a(totalString));
            }
            if (ScoreboardHUD.scoreboardTitle) {
                TextRenderer.drawScaledString((String)displayName, (float)(this.width / 2.0f - (float)ScoreboardHUD.fontRenderer.func_78256_a(displayName) / 2.0f), (float)1.0f, (int)-1, (TextRenderer.TextType)TextRenderer.TextType.toType((int)this.textType), (float)1.0f);
            }
            UGraphics.GL.translate((float)0.0f, (float)this.height, (float)0.0f);
            counter = 0;
            for (Score score : sortedScores) {
                team = scoreboard.func_96509_i(score.func_96653_e());
                playerName = ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e());
                yPos = -(++counter) * ScoreboardHUD.fontRenderer.field_78288_b;
                TextRenderer.drawScaledString((String)playerName, (float)1.0f, (float)yPos, (int)-1, (TextRenderer.TextType)TextRenderer.TextType.toType((int)this.textType), (float)1.0f);
                if (!showScorePoints) continue;
                scorePoints = "" + score.func_96652_c();
                TextRenderer.drawScaledString((String)scorePoints, (float)(this.width - (float)ScoreboardHUD.fontRenderer.func_78256_a(scorePoints) - 1.0f), (float)yPos, (int)this.scorePointsColor.getRGB(), (TextRenderer.TextType)TextRenderer.TextType.toType((int)this.textType), (float)1.0f);
            }
            this.width = displayNameStringWidth + 2;
            this.height = sortedScores.size() * ScoreboardHUD.fontRenderer.field_78288_b + (ScoreboardHUD.scoreboardTitle != false ? 10 : 1);
        }

        private boolean isNonConsecutive(ScoreObjective scoreObjective) {
            int[] scorePoints = scoreObjective.func_96682_a().func_96534_i(scoreObjective).stream().mapToInt(Score::func_96652_c).toArray();
            if (scorePoints.length > 1) {
                for (int line = 1; line < scorePoints.length; ++line) {
                    if (scorePoints[line] == scorePoints[line - 1] + 1) continue;
                    return true;
                }
            }
            return false;
        }

        protected void drawBackground(float x, float y, float width, float height, float scale) {
            NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
            nanoVGHelper.setupAndDraw(true, vg -> {
                if (this.rounded) {
                    if (scoreboardTitle) {
                        ScissorHelper helper = ScissorHelper.INSTANCE;
                        helper.scissor(vg, x, y, width, (float)ScoreboardHUD.fontRenderer.field_78288_b + this.paddingY);
                        nanoVGHelper.drawRoundedRectVaried(vg, x, y, width, height, this.titleColor.getRGB(), this.cornerRadius * scale, this.cornerRadius * scale, 0.0f, 0.0f);
                        helper.clearScissors(vg);
                        helper.scissor(vg, x, y + (float)ScoreboardHUD.fontRenderer.field_78288_b + this.paddingY, width, height - (float)ScoreboardHUD.fontRenderer.field_78288_b - this.paddingY);
                        nanoVGHelper.drawRoundedRectVaried(vg, x, y, width, height, this.bgColor.getRGB(), 0.0f, 0.0f, this.cornerRadius * scale, this.cornerRadius * scale);
                        helper.clearScissors(vg);
                    } else {
                        nanoVGHelper.drawRoundedRect(vg, x, y, width, height, this.bgColor.getRGB(), this.cornerRadius * scale);
                    }
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, this.borderColor.getRGB(), this.cornerRadius * scale, this.borderSize * scale);
                    }
                } else {
                    if (scoreboardTitle) {
                        nanoVGHelper.drawRect(vg, x, y, width, (float)ScoreboardHUD.fontRenderer.field_78288_b + this.paddingY, this.titleColor.getRGB());
                        nanoVGHelper.drawRect(vg, x, y + (float)ScoreboardHUD.fontRenderer.field_78288_b + this.paddingY, width, height - (float)ScoreboardHUD.fontRenderer.field_78288_b - this.paddingY, this.bgColor.getRGB());
                    } else {
                        nanoVGHelper.drawRect(vg, x, y, width, height, this.bgColor.getRGB());
                    }
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, this.borderColor.getRGB(), 0.0f, this.borderSize * scale);
                    }
                }
            });
        }

        protected float getWidth(float scale, boolean example) {
            return this.width * scale;
        }

        protected float getHeight(float scale, boolean example) {
            return this.height * scale;
        }
    }
}

