/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.hud;

import cc.polyfrost.oneconfig.config.annotations.Color;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.annotations.DualOption;
import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Info;
import cc.polyfrost.oneconfig.config.annotations.Slider;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.config.data.InfoType;
import cc.polyfrost.oneconfig.hud.BasicHud;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.polyfrost.vanillahud.config.HudConfig;
import org.polyfrost.vanillahud.utils.EaseOutQuart;
import org.polyfrost.vanillahud.utils.TabListManager;

public class TabList
extends HudConfig {
    @HUD(name="TabList")
    public static TabHud hud = new TabHud();
    @Exclude
    public static int width;
    @Exclude
    public static int height;
    @Exclude
    public static boolean isGuiIngame;
    @Exclude
    public static EaseOutQuart animation;

    public TabList() {
        super("TabList", "vanilla-hud/tab.json");
        this.initialize();
        TabListManager.asyncFetchFallbackList();
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onScreenOpened(GuiScreenEvent.InitGuiEvent.Post event) {
                if (HudCore.editing) {
                    TabListManager.asyncUpdateList();
                }
            }
        });
    }

    static {
        isGuiIngame = false;
        animation = new EaseOutQuart(0.0f, 0.0f, 0.0f, false);
    }

    public static class TabHud
    extends BasicHud {
        @Switch(name="Animations")
        public static boolean tabAnimation = true;
        @Slider(name="Duration", min=50.0f, max=1000.0f)
        public static float tabDuration = 400.0f;
        @Slider(name="Tab Player Limit", description="Change how many players can display on tab.", min=10.0f, max=120.0f)
        public static int tabPlayerLimit = 80;
        @DualOption(name="Mode", left="Held", right="Toggle")
        public static boolean displayMode = false;
        @Dropdown(name="Text Type", options={"No Shadow", "Shadow", "Full Shadow"})
        public static int textType = 1;
        @Switch(name="Show Header")
        public static boolean showHeader = true;
        @Switch(name="Show Footer")
        public static boolean showFooter = true;
        @Switch(name="Show Self At Top")
        public static boolean selfAtTop = false;
        @Switch(name="Show Player's Head")
        public static boolean showHead = true;
        @Switch(name="Better Hat Layer")
        public static boolean betterHatLayer = false;
        @Switch(name="Show Player's Ping")
        public static boolean showPing = true;
        @Switch(name="Use Number Ping", size=2)
        public static boolean numberPing = true;
        @DualOption(name="Ping Text", left="Small", right="Full")
        public static boolean pingType = false;
        @Switch(name="Hide False Ping", description="Hides falsified ping numbers such as a ping of 0 or 1 when on Hypixel")
        public static boolean hideFalsePing = true;
        @Color(name="Ping Between 0 and 75")
        public static OneColor pingLevelOne = new OneColor("55FF55FF");
        @Color(name="Ping Between 75 and 145")
        public static OneColor pingLevelTwo = new OneColor("00AA00FF");
        @Color(name="Ping Between 145 and 200")
        public static OneColor pingLevelThree = new OneColor("FFFF55FF");
        @Color(name="Ping Between 200 and 300")
        public static OneColor pingLevelFour = new OneColor("FFAA00FF");
        @Color(name="Ping Between 300 and 400")
        public static OneColor pingLevelFive = new OneColor("FF5555FF");
        @Color(name="Ping Above 400")
        public static OneColor pingLevelSix = new OneColor("AA0000FF");
        @Color(name="Tab Widget Color", size=2)
        public static OneColor tabWidgetColor = new OneColor(0x20FFFFFF);
        @Info(text="Tablist might goes over screen", type=InfoType.WARNING)
        private static Runnable info = () -> {};
        @Switch(name="Fix TabList Entry Width")
        public static boolean fixWidth = false;
        public static boolean updatedHeight;
        @Exclude
        private static boolean lastToggled;

        public TabHud() {
            super(true, 960.0f, 10.0f);
            this.ignoreCaching = true;
            this.showInDebug = true;
        }

        public static int getTabPlayerLimit() {
            return MathHelper.func_76125_a((int)tabPlayerLimit, (int)10, (int)120);
        }

        protected void draw(UMatrixStack matrices, float x, float y, float scale, boolean example) {
        }

        protected void drawBackground(float x, float y, float width, float height, float scale) {
            super.drawBackground(x, y, width, height, scale);
        }

        public boolean shouldRender() {
            return this.isEnabled() && this.shouldShow() && isGuiIngame ^ this.isCachingIgnored();
        }

        public void doAnimation(boolean toggled) {
            if (toggled != lastToggled) {
                lastToggled = toggled;
                if (tabAnimation) {
                    animation = new EaseOutQuart(tabDuration, this.position.getHeight(), 0.0f, toggled);
                }
            }
            if (animation.isFinished()) {
                if (toggled) {
                    animation = new EaseOutQuart(0.0f, 0.0f, this.position.getHeight(), false);
                }
            } else if (animation.getEnd() != 0.0f && toggled && animation.getEnd() != this.position.getHeight()) {
                animation = new EaseOutQuart(tabDuration - (float)Minecraft.func_71386_F() + (float)TabList.animation.startTime, animation.get(), this.position.getHeight(), false);
            }
        }

        public void drawBG() {
            if (!this.background || !this.shouldRender() || animation.get() == 0.0f || animation.isFinished() && !lastToggled) {
                return;
            }
            this.drawBackground(this.position.getX(), this.position.getY(), this.position.getWidth(), animation.get(), this.scale);
        }

        public float getPaddingY() {
            return this.paddingY * this.scale;
        }

        protected boolean shouldDrawBackground() {
            return false;
        }

        protected float getWidth(float scale, boolean example) {
            return (float)width * scale;
        }

        protected float getHeight(float scale, boolean example) {
            return (float)height * scale;
        }

        public OneColor getBackgroundColor() {
            return this.bgColor;
        }

        protected void resetPosition() {
            super.resetPosition();
            TabList.hud.position.setY(20.0f);
        }
    }
}

