/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.hud;

import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.hud.SingleTextHud;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.TextRenderer;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import org.polyfrost.vanillahud.config.HudConfig;
import org.polyfrost.vanillahud.mixin.minecraft.GuiIngameAccessor;
import org.polyfrost.vanillahud.mixin.minecraft.MinecraftAccessor;

public class Title
extends HudConfig {
    @HUD(name="Title", category="Title")
    public TitleHUD titleHUD = new TitleHUD();
    @HUD(name="Subtitle", category="Subtitle")
    public SubTitleHUD subtitleHUD = new SubTitleHUD();

    public Title() {
        super("Title", "title.json");
        this.initialize();
    }

    public static class SubTitleHUD
    extends TitleHUD {
        @Exclude
        private static final String EXAMPLE_TEXT = "Subtitle";

        public SubTitleHUD() {
            super(960.0f, 558.0f, 2.0f);
        }

        @Override
        protected String getText(boolean example) {
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)UMinecraft.getMinecraft().field_71456_v;
            if ((ingameGUI == null || ingameGUI.getDisplayedSubTitle().isEmpty() || !this.shouldShow()) && example) {
                this.opacity = 255;
                return EXAMPLE_TEXT;
            }
            return ingameGUI.getDisplayedSubTitle();
        }
    }

    public static class TitleHUD
    extends SingleTextHud {
        @Switch(name="Instant Fade")
        private static boolean instantFade = false;
        @Exclude
        protected int opacity;
        @Exclude
        private static final String EXAMPLE_TEXT = "Title";

        public TitleHUD() {
            this(960.0f, 516.0f, 4.0f);
        }

        public TitleHUD(float x, float y, float scale) {
            super("", true, x, y, scale, false, false, 2.0f, 2.0f, 2.0f, new OneColor(0, 0, 0, 80), false, 2.0f, new OneColor(0, 0, 0));
            this.textType = 1;
            this.showInDebug = true;
        }

        protected void drawLine(String line, float x, float y, float scale) {
            int color = ColorUtils.setAlpha((int)this.color.getRGB(), (int)Math.min(this.color.getAlpha(), this.opacity));
            UGraphics.enableBlend();
            TextRenderer.drawScaledString((String)line, (float)x, (float)y, (int)color, (TextRenderer.TextType)TextRenderer.TextType.toType((int)this.textType), (float)scale);
        }

        protected void drawLine(String line, float x, float y, OneColor c, float scale) {
            int color = ColorUtils.setAlpha((int)c.getRGB(), (int)Math.min(c.getAlpha(), this.opacity));
            UGraphics.enableBlend();
            TextRenderer.drawScaledString((String)line, (float)x, (float)y, (int)color, (TextRenderer.TextType)TextRenderer.TextType.toType((int)this.textType), (float)scale);
        }

        protected boolean shouldShow() {
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)UMinecraft.getMinecraft().field_71456_v;
            if (ingameGUI == null || ingameGUI.getTitlesTimer() <= 0) {
                return false;
            }
            float age = (float)ingameGUI.getTitlesTimer() - ((MinecraftAccessor)UMinecraft.getMinecraft()).getTimer().field_74281_c;
            int o = 255;
            if (ingameGUI.getTitlesTimer() > ingameGUI.getTitleFadeOut() + ingameGUI.getTitleDisplayTime()) {
                float f = (float)(ingameGUI.getTitleFadeIn() + ingameGUI.getTitleFadeOut() + ingameGUI.getTitleDisplayTime()) - age;
                o = (int)(f * 255.0f / (float)ingameGUI.getTitleFadeIn());
            } else if (ingameGUI.getTitlesTimer() <= ingameGUI.getTitleFadeOut()) {
                o = (int)(age * 255.0f / (float)ingameGUI.getTitleFadeOut());
            }
            if (o > 255) {
                o = 255;
            }
            this.opacity = instantFade ? 255 : o;
            return o > 8 && super.shouldShow();
        }

        protected void drawBackground(float x, float y, float width, float height, float scale) {
            NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
            nanoVGHelper.setupAndDraw(true, vg -> {
                int bgColor = ColorUtils.setAlpha((int)this.bgColor.getRGB(), (int)Math.min(this.bgColor.getAlpha(), this.opacity));
                int borderColor = ColorUtils.setAlpha((int)this.borderColor.getRGB(), (int)Math.min(this.borderColor.getAlpha(), this.opacity));
                if (this.rounded) {
                    nanoVGHelper.drawRoundedRect(vg, x, y, width, height, bgColor, this.cornerRadius * scale);
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, borderColor, this.cornerRadius * scale, this.borderSize * scale);
                    }
                } else {
                    nanoVGHelper.drawRect(vg, x, y, width, height, bgColor);
                    if (this.border) {
                        nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, borderColor, 0.0f, this.borderSize * scale);
                    }
                }
            });
        }

        protected String getText(boolean example) {
            GuiIngameAccessor ingameGUI = (GuiIngameAccessor)UMinecraft.getMinecraft().field_71456_v;
            if (example) {
                this.opacity = 255;
                return EXAMPLE_TEXT;
            }
            return ingameGUI.getDisplayedTitle();
        }

        public OneColor getColor() {
            return this.color;
        }
    }
}

