/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.mixin.minecraft;

import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import cc.polyfrost.oneconfig.renderer.TextRenderer;
import com.google.common.collect.Ordering;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.polyfrost.vanillahud.VanillaHUD;
import org.polyfrost.vanillahud.hooks.TabHook;
import org.polyfrost.vanillahud.hud.TabList;
import org.polyfrost.vanillahud.mixin.minecraft.GuiPlayerTabOverlayAccessor;
import org.polyfrost.vanillahud.utils.TabListManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={GuiPlayerTabOverlay.class}, priority=1100)
public abstract class GuiPlayerTabOverlayMixin {
    @Shadow
    private IChatComponent field_175256_i;
    @Shadow
    private IChatComponent field_175255_h;
    @Shadow
    @Final
    private Minecraft field_175250_f;
    @Unique
    private static final IChatComponent tab$exampleHeader = new ChatComponentText("Tab List");
    @Unique
    private static final IChatComponent tab$exampleFooter = new ChatComponentText("VanillaHud");
    @Unique
    private int entryX;
    @Unique
    private int entryWidth;
    @Unique
    List<NetworkPlayerInfo> renderingList;
    @Unique
    private List<NetworkPlayerInfo> currentList;
    @Unique
    private NetworkPlayerInfo info;

    @ModifyVariable(method={"renderPlayerlist"}, at=@At(value="STORE", ordinal=0), ordinal=9)
    private int resetY(int y) {
        return !VanillaHUD.isForceDisableCompactTab() ? 1 : y;
    }

    @ModifyVariable(method={"renderPlayerlist"}, at=@At(value="STORE", ordinal=0), ordinal=7)
    private int captureEntryWidth(int width) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return width;
        }
        this.entryWidth = width;
        return width;
    }

    @ModifyVariable(method={"renderPlayerlist"}, at=@At(value="STORE", ordinal=0), ordinal=14)
    private int captureEntryX(int x) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return x;
        }
        this.entryX = x;
        return x;
    }

    @ModifyConstant(method={"renderPlayerlist"}, constant={@Constant(intValue=13)})
    private int pingWidth(int constant) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return constant;
        }
        int width = 3;
        if (TabList.TabHud.numberPing && TabList.TabHud.pingType) {
            int maxWidth = 0;
            for (NetworkPlayerInfo info : this.renderingList) {
                int textWidth = this.field_175250_f.field_71466_p.func_78256_a(String.valueOf(info.func_178853_c()));
                if (textWidth <= maxWidth) continue;
                maxWidth = textWidth;
            }
            width += maxWidth;
        } else {
            width += 10;
        }
        return Math.max(width, 13);
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;header:Lnet/minecraft/util/IChatComponent;"))
    private IChatComponent modifyHeader(GuiPlayerTabOverlay instance) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return this.field_175256_i;
        }
        if (!TabList.TabHud.showHeader) {
            return null;
        }
        if (HudCore.editing) {
            return tab$exampleHeader;
        }
        return this.field_175256_i;
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;footer:Lnet/minecraft/util/IChatComponent;"))
    private IChatComponent modifyFooter(GuiPlayerTabOverlay instance) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return this.field_175255_h;
        }
        if (!TabList.TabHud.showFooter) {
            return null;
        }
        if (HudCore.editing) {
            return tab$exampleFooter;
        }
        return this.field_175255_h;
    }

    @Inject(method={"renderPlayerlist"}, at={@At(value="HEAD")})
    private void translate(int width, Scoreboard scoreboardIn, ScoreObjective scoreObjectiveIn, CallbackInfo ci) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        TabList.TabHud hud = TabList.hud;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(-width / 2) * hud.getScale() + hud.position.getCenterX()), (float)(hud.position.getY() + hud.getPaddingY()), (float)0.0f);
        GlStateManager.func_179152_a((float)hud.getScale(), (float)hud.getScale(), (float)1.0f);
    }

    @Inject(method={"renderPlayerlist"}, at={@At(value="TAIL")})
    private void pop(int width, Scoreboard scoreboardIn, ScoreObjective scoreObjectiveIn, CallbackInfo ci) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        GlStateManager.func_179121_F();
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Ordering;sortedCopy(Ljava/lang/Iterable;)Ljava/util/List;"))
    private List<NetworkPlayerInfo> list(Ordering<NetworkPlayerInfo> instance, Iterable<NetworkPlayerInfo> elements) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return instance.sortedCopy(elements);
        }
        List list = instance.sortedCopy(elements);
        if (TabList.TabHud.selfAtTop && !VanillaHUD.isCompactTab()) {
            for (NetworkPlayerInfo info : list) {
                if (!info.func_178845_a().getId().equals(this.field_175250_f.field_71439_g.func_146103_bH().getId())) continue;
                list.remove(info);
                list.add(0, info);
                break;
            }
        }
        this.renderingList = HudCore.editing ? TabListManager.devInfo : list;
        return this.renderingList;
    }

    @ModifyArgs(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawRect(IIIII)V", ordinal=0))
    private void cancelRects(Args args) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        TabHook.cancelRect = true;
    }

    @ModifyArgs(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawRect(IIIII)V", ordinal=1))
    private void captureWidth(Args args) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        TabList.width = (Integer)args.get(2) - (Integer)args.get(0);
        TabList.height = (Integer)args.get(3);
        TabHook.cancelRect = true;
    }

    @ModifyArgs(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawRect(IIIII)V", ordinal=3))
    private void captureHeight(Args args) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        TabList.height = (Integer)args.get(3);
        TabHook.cancelRect = true;
    }

    @ModifyArgs(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawRect(IIIII)V", ordinal=2))
    private void widget(Args args) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        if (TabHook.gettingSize) {
            TabHook.cancelRect = true;
        }
    }

    @ModifyConstant(method={"renderPlayerlist"}, constant={@Constant(intValue=20, ordinal=0)})
    private int limit(int constant) {
        return HudCore.editing && !VanillaHUD.isForceDisableCompactTab() ? 10 : constant;
    }

    @Inject(method={"renderPlayerlist"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/network/NetworkPlayerInfo;getGameProfile()Lcom/mojang/authlib/GameProfile;", ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawPing(IIILnet/minecraft/client/network/NetworkPlayerInfo;)V"))})
    private void preHeadTransform(int width, Scoreboard scoreboardIn, ScoreObjective scoreObjectiveIn, CallbackInfo ci) {
        if (TabHook.gettingSize) {
            return;
        }
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(TabList.TabHud.showHead ? 0.0f : -8.0f), (float)0.0f, (float)0.0f);
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I"))
    private int drawText(FontRenderer instance, String text, float x, float y, int color) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return instance.func_175063_a(text, x, y, color);
        }
        if (!TabHook.gettingSize) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            TextRenderer.drawScaledString((String)text, (float)x, (float)y, (int)color, (TextRenderer.TextType)TextRenderer.TextType.toType((int)TabList.TabHud.textType), (float)1.0f);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        return 0;
    }

    @Inject(method={"renderPlayerlist"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I", shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/network/NetworkPlayerInfo;getGameProfile()Lcom/mojang/authlib/GameProfile;", ordinal=1), to=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawPing(IIILnet/minecraft/client/network/NetworkPlayerInfo;)V"))})
    private void postHeadTransform(int width, Scoreboard scoreboardIn, ScoreObjective scoreObjectiveIn, CallbackInfo ci) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        if (TabHook.gettingSize) {
            return;
        }
        GlStateManager.func_179121_F();
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;drawScaledCustomSizeModalRect(IIFFIIIIFF)V", ordinal=0))
    private void playerHead(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        if (!(TabList.TabHud.showHead && !TabHook.gettingSize || VanillaHUD.isForceDisableCompactTab())) {
            return;
        }
        Gui.func_152125_a((int)x, (int)y, (float)u, (float)v, (int)uWidth, (int)vHeight, (int)width, (int)height, (float)tileWidth, (float)tileHeight);
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;drawScaledCustomSizeModalRect(IIFFIIIIFF)V", ordinal=1))
    private void playerHead1(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        if (!(TabList.TabHud.showHead && !TabHook.gettingSize || VanillaHUD.isForceDisableCompactTab())) {
            return;
        }
        if (TabList.TabHud.betterHatLayer) {
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
            Gui.func_152125_a((int)x, (int)y, (float)u, (float)v, (int)uWidth, (int)vHeight, (int)9, (int)9, (float)tileWidth, (float)tileHeight);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
        } else {
            Gui.func_152125_a((int)x, (int)y, (float)u, (float)v, (int)uWidth, (int)vHeight, (int)width, (int)height, (float)tileWidth, (float)tileHeight);
        }
    }

    @Inject(method={"drawScoreboardValues"}, at={@At(value="HEAD")})
    private void captureInfo(ScoreObjective scoreObjective, int i, String string, int j, int k, NetworkPlayerInfo networkPlayerInfo, CallbackInfo ci) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        this.info = networkPlayerInfo;
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawScoreboardValues(Lnet/minecraft/scoreboard/ScoreObjective;ILjava/lang/String;IILnet/minecraft/client/network/NetworkPlayerInfo;)V"))
    private void scoreboard(GuiPlayerTabOverlay instance, ScoreObjective scoreObjective, int i, String string, int j, int k, NetworkPlayerInfo networkPlayerInfo) {
        if (TabHook.gettingSize && !VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        ((GuiPlayerTabOverlayAccessor)instance).renderScore(scoreObjective, i, string, j, k, networkPlayerInfo);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Redirect(method={"drawScoreboardValues"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;drawStringWithShadow(Ljava/lang/String;FFI)I", ordinal=1))
    private int translate(FontRenderer instance, String text, float x, float y, int color) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return instance.func_175063_a(text, x, y, color);
        }
        if (!TabHook.gettingSize) {
            int ping = this.info.func_178853_c();
            boolean offset = TabList.TabHud.numberPing && TabList.TabHud.hideFalsePing && (ping <= 1 || ping >= 999) || !TabList.TabHud.showPing;
            float textWidth = this.field_175250_f.field_71466_p.func_78256_a(text);
            float textX = offset ? (float)(this.entryX + this.entryWidth) - textWidth - 1.0f : x;
            TextRenderer.drawScaledString((String)text, (float)textX, (float)y, (int)color, (TextRenderer.TextType)TextRenderer.TextType.toType((int)TabList.TabHud.textType), (float)1.0f);
        }
        return 0;
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiPlayerTabOverlay;drawPing(IIILnet/minecraft/client/network/NetworkPlayerInfo;)V"))
    private void redirectDrawPing(GuiPlayerTabOverlay instance, int width, int x, int y, NetworkPlayerInfo networkPlayerInfoIn) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            ((GuiPlayerTabOverlayAccessor)instance).renderPing(width, x, y, networkPlayerInfoIn);
            return;
        }
        if (TabHook.gettingSize) {
            return;
        }
        if (!TabList.TabHud.showPing) {
            return;
        }
        if (TabList.TabHud.numberPing) {
            int ping = networkPlayerInfoIn.func_178853_c();
            if (TabList.TabHud.hideFalsePing && (ping <= 1 || ping >= 999)) {
                return;
            }
            OneColor color = GuiPlayerTabOverlayMixin.tab$getColor(ping);
            String pingString = String.valueOf(ping);
            int textWidth = this.field_175250_f.field_71466_p.func_78256_a(String.valueOf(ping));
            if (!TabList.TabHud.pingType) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                TextRenderer.drawScaledString((String)pingString, (float)(2 * (x + width) - textWidth - 4), (float)(2 * y + 4), (int)color.getRGB(), (TextRenderer.TextType)TextRenderer.TextType.toType((int)TabList.TabHud.textType), (float)1.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            } else {
                TextRenderer.drawScaledString((String)pingString, (float)(x + width - textWidth - 1), (float)y, (int)color.getRGB(), (TextRenderer.TextType)TextRenderer.TextType.toType((int)TabList.TabHud.textType), (float)1.0f);
            }
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            ((GuiPlayerTabOverlayAccessor)instance).renderPing(width, x, y, networkPlayerInfoIn);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    @Unique
    private static OneColor tab$getColor(int ping) {
        return ping >= 400 ? TabList.TabHud.pingLevelSix : (ping >= 300 ? TabList.TabHud.pingLevelFive : (ping >= 200 ? TabList.TabHud.pingLevelFour : (ping >= 145 ? TabList.TabHud.pingLevelThree : (ping >= 75 ? TabList.TabHud.pingLevelTwo : TabList.TabHud.pingLevelOne))));
    }

    @ModifyConstant(method={"renderPlayerlist"}, constant={@Constant(intValue=0x20FFFFFF)})
    private int tabOpacity(int opacity) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return opacity;
        }
        return TabList.TabHud.tabWidgetColor.getRGB();
    }

    @ModifyConstant(method={"renderPlayerlist"}, constant={@Constant(intValue=80)})
    private int changePlayerCount(int original) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return original;
        }
        return TabList.TabHud.getTabPlayerLimit();
    }

    @ModifyVariable(method={"renderPlayerlist"}, at=@At(value="STORE"), ordinal=0)
    private List<NetworkPlayerInfo> setLimit(List<NetworkPlayerInfo> value) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return value;
        }
        this.currentList = value.subList(0, Math.min(value.size(), TabList.TabHud.getTabPlayerLimit()));
        return this.currentList;
    }

    @Redirect(method={"renderPlayerlist"}, at=@At(value="INVOKE", target="Ljava/lang/Math;min(II)I", ordinal=1))
    private int noLimit(int a, int b) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return Math.min(a, b);
        }
        if (!TabList.TabHud.fixWidth) {
            return Math.min(a, b);
        }
        return a;
    }

    @Inject(method={"renderPlayerlist"}, at={@At(value="TAIL")})
    private void alpha(int width, Scoreboard scoreboardIn, ScoreObjective scoreObjectiveIn, CallbackInfo ci) {
        if (VanillaHUD.isForceDisableCompactTab()) {
            return;
        }
        GlStateManager.func_179141_d();
    }
}

