/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.mixin.minecraft;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.polyfrost.vanillahud.config.ModConfig;
import org.polyfrost.vanillahud.hooks.TooltipHook;
import org.polyfrost.vanillahud.hud.ScrollableTooltip;
import org.polyfrost.vanillahud.utils.EaseOutQuart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiUtils.class}, remap=false)
public class GuiUtilsMixin {
    @Unique
    private static int gui$tooltipY;
    @Unique
    private static int gui$tooltipHeight;
    @Unique
    private static boolean gui$overScreen;
    @Unique
    private static List<String> gui$lines;

    @ModifyVariable(method={"drawHoveringText"}, at=@At(value="STORE"), name={"tooltipY"})
    private static int captureY(int y) {
        gui$tooltipY = gui$overScreen && ModConfig.scrollableTooltip.enabled && ScrollableTooltip.startAtTop ? 6 : y;
        return gui$tooltipY;
    }

    @ModifyVariable(method={"drawHoveringText"}, at=@At(value="STORE"), name={"tooltipHeight"})
    private static int captureHeight(int height) {
        gui$tooltipHeight = height;
        return height;
    }

    @Inject(method={"drawHoveringText"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fml/client/config/GuiUtils;drawGradientRect(IIIIIII)V", ordinal=0)})
    private static void setY(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, CallbackInfo ci) {
        float current = TooltipHook.gui$animationY.get();
        int bottom = gui$tooltipY + gui$tooltipHeight + 3;
        int top = gui$tooltipY - 4;
        int height = bottom - top;
        boolean bl = gui$overScreen = height + 4 > screenHeight;
        if (!textLines.equals(gui$lines)) {
            TooltipHook.resetScrolling();
            gui$lines = textLines;
        }
        TooltipHook.isScrolling = ModConfig.scrollableTooltip.enabled && (gui$overScreen || top < 0);
        int mouseDWheel = Mouse.getDWheel();
        if (TooltipHook.isScrolling) {
            if (mouseDWheel < 0) {
                TooltipHook.gui$scrollY -= 10;
            } else if (mouseDWheel > 0) {
                TooltipHook.gui$scrollY += 10;
            }
            TooltipHook.gui$scrollY = MathHelper.func_76125_a((int)TooltipHook.gui$scrollY, (int)(screenHeight - bottom - 5), (int)(2 - top));
        }
        if ((float)TooltipHook.gui$scrollY != TooltipHook.gui$animationY.getEnd()) {
            TooltipHook.gui$animationY = new EaseOutQuart(200.0f, current, TooltipHook.gui$scrollY, false);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)TooltipHook.gui$animationY.get(), (float)0.0f);
    }

    @Inject(method={"drawHoveringText"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GlStateManager;enableLighting()V")})
    private static void pop(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, CallbackInfo ci) {
        GlStateManager.func_179109_b((float)0.0f, (float)(-TooltipHook.gui$animationY.get()), (float)0.0f);
    }
}

