/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.mixin.oneconfig;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.hud.HUDUtils;
import cc.polyfrost.oneconfig.hud.Hud;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import java.lang.reflect.Field;
import org.polyfrost.vanillahud.hud.Scoreboard;
import org.polyfrost.vanillahud.hud.TabList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HUDUtils.class}, remap=false)
public class HUDUtilsMixin {
    @Inject(method={"addHudOptions"}, at={@At(value="TAIL")})
    private static void hudUtils$modifyOptions(OptionPage page, Field field, Object instance, Config config, CallbackInfo ci) {
        Hud hud = (Hud)ConfigUtils.getField((Field)field, (Object)instance);
        if (!(hud instanceof TabList.TabHud) && !(hud instanceof Scoreboard.ScoreboardHUD)) {
            return;
        }
        HudCore.hudOptions.removeIf(HUDUtilsMixin::hudUtils$addDependency);
        HUD hudAnnotation = field.getAnnotation(HUD.class);
        ConfigUtils.getSubCategory((OptionPage)page, (String)hudAnnotation.category(), (String)hudAnnotation.subcategory()).options.removeIf(HUDUtilsMixin::hudUtils$addDependency);
    }

    private static boolean hudUtils$addDependency(BasicOption option) {
        String fieldName = option.getField().getName();
        if (fieldName.contains("pingLevel")) {
            fieldName = "pingLevel";
        }
        Object hud = option.getParent();
        boolean isTabList = hud instanceof TabList.TabHud;
        boolean isScoreboard = hud instanceof Scoreboard.ScoreboardHUD;
        if (!isTabList && !isScoreboard) {
            return false;
        }
        switch (fieldName) {
            case "pingType": 
            case "hideFalsePing": 
            case "pingLevel": {
                option.addDependency("showPing", () -> TabList.TabHud.showPing);
                option.addDependency("numberPing", () -> TabList.TabHud.numberPing);
                break;
            }
            case "numberPing": {
                option.addDependency("showPing", () -> TabList.TabHud.showPing);
                break;
            }
            case "scorePointsColor": {
                option.addDependency("scoreboardPoints", () -> Scoreboard.ScoreboardHUD.scoreboardPoints > 0);
                break;
            }
            case "persistentTitle": 
            case "titleColor": {
                option.addDependency("scoreboardTitle", () -> Scoreboard.ScoreboardHUD.scoreboardTitle);
            }
        }
        return false;
    }
}

