/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.vanillahud.utils;

import cc.polyfrost.oneconfig.utils.Multithreading;
import cc.polyfrost.oneconfig.utils.NetworkUtils;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;

public class TabListManager {
    private static final Gson gson = new GsonBuilder().create();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final String devListURL = "https://raw.githubusercontent.com/Polyfrost/VanillaHUD/main/tablist_uuids.json";
    private static final List<String> fallbackDevUUIDs = Arrays.asList("0b4d470f-f2fb-4874-9334-1eaef8ba4804", "c8bf4768-af44-48cb-a259-01e42fb7bc79", "0e3ee1e0-f4d2-4550-8fe9-4f7a0d2cd08a", "0d68ec06-ec8f-4558-959f-7a6d7efd7fa5", "a5331404-0e77-440e-8bef-24c071dac1ae");
    public static List<NetworkPlayerInfo> devInfo = ImmutableList.of();

    public static void asyncFetchFallbackList() {
        Multithreading.runAsync(() -> {
            devInfo = fallbackDevUUIDs.stream().map(UUID::fromString).map(TabListManager::getProfile).map(NetworkPlayerInfo::new).collect(Collectors.toList());
        });
    }

    public static GameProfile getProfile(UUID uuid) {
        return mc.func_152347_ac().fillProfileProperties(new GameProfile(uuid, null), true);
    }

    public static void asyncUpdateList() {
        Multithreading.runAsync(TabListManager::updateList);
    }

    private static void updateList() {
        try {
            String input = NetworkUtils.getString((String)devListURL);
            if (input == null) {
                return;
            }
            DevList list = (DevList)gson.fromJson(input, DevList.class);
            devInfo = list.toNetworkInfoList();
        }
        catch (Exception exception) {
            new RuntimeException("Failed to load list", exception).printStackTrace();
        }
    }

    private static class DevList
    extends ArrayList<DevEntry> {
        private DevList() {
        }

        public List<NetworkPlayerInfo> toNetworkInfoList() {
            return this.stream().map(DevEntry::getUUID).map(TabListManager::getProfile).map(NetworkPlayerInfo::new).collect(Collectors.toList());
        }

        private static class DevEntry {
            public String name;
            public String id;

            private DevEntry() {
            }

            public UUID getUUID() {
                return UUID.fromString(this.id);
            }
        }
    }
}

