/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class Lang {
    private static final Splitter splitter = Splitter.on((char)'=').limit(2);
    private static final Pattern pattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void resourcesReloaded() {
        Map localeProperties = bnq.getLocaleProperties();
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "optifine/lang/";
        String EN_US = "en_US";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        if (!Config.getGameSettings().aN.equals(EN_US)) {
            listFiles.add(PREFIX + Config.getGameSettings().aN + SUFFIX);
        }
        String[] files = listFiles.toArray(new String[listFiles.size()]);
        Lang.loadResources(Config.getDefaultResourcePack(), files, localeProperties);
        bnk[] resourcePacks = Config.getResourcePacks();
        for (int i2 = 0; i2 < resourcePacks.length; ++i2) {
            bnk rp = resourcePacks[i2];
            Lang.loadResources(rp, files, localeProperties);
        }
    }

    private static void loadResources(bnk rp, String[] files, Map localeProperties) {
        try {
            for (int i2 = 0; i2 < files.length; ++i2) {
                InputStream in;
                String file = files[i2];
                jy loc = new jy(file);
                if (!rp.b(loc) || (in = rp.a(loc)) == null) continue;
                Lang.loadLocaleData(in, localeProperties);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void loadLocaleData(InputStream is, Map localeProperties) throws IOException {
        Iterator it = IOUtils.readLines((InputStream)is, (Charset)Charsets.UTF_8).iterator();
        is.close();
        while (it.hasNext()) {
            String[] parts;
            String line = (String)it.next();
            if (line.isEmpty() || line.charAt(0) == '#' || (parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class)) == null || parts.length != 2) continue;
            String key = parts[0];
            String value = pattern.matcher(parts[1]).replaceAll("%$1s");
            localeProperties.put(key, value);
        }
    }

    public static String get(String key) {
        return bnq.a(key, new Object[0]);
    }

    public static String get(String key, String def) {
        String str = bnq.a(key, new Object[0]);
        if (str == null || str.equals(key)) {
            return def;
        }
        return str;
    }

    public static String getOn() {
        return bnq.a("options.on", new Object[0]);
    }

    public static String getOff() {
        return bnq.a("options.off", new Object[0]);
    }

    public static String getFast() {
        return bnq.a("options.graphics.fast", new Object[0]);
    }

    public static String getFancy() {
        return bnq.a("options.graphics.fancy", new Object[0]);
    }

    public static String getDefault() {
        return bnq.a("generator.default", new Object[0]);
    }
}

