/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.Properties;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntityRule;
import net.optifine.config.ConnectedParser;

public class RandomEntityProperties {
    public String name = null;
    public String basePath = null;
    public jy[] resourceLocations = null;
    public RandomEntityRule[] rules = null;

    public RandomEntityProperties(String path, jy[] variants) {
        ConnectedParser cp = new ConnectedParser("RandomEntities");
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.resourceLocations = variants;
    }

    public RandomEntityProperties(Properties props, String path, jy baseResLoc) {
        ConnectedParser cp = new ConnectedParser("RandomEntities");
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.rules = this.parseRules(props, path, baseResLoc, cp);
    }

    public jy getTextureLocation(jy loc, IRandomEntity randomEntity) {
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (!rule.matches(randomEntity)) continue;
                return rule.getTextureLocation(loc, randomEntity.getId());
            }
        }
        if (this.resourceLocations != null) {
            int randomId = randomEntity.getId();
            int index = randomId % this.resourceLocations.length;
            return this.resourceLocations[index];
        }
        return loc;
    }

    private RandomEntityRule[] parseRules(Properties props, String pathProps, jy baseResLoc, ConnectedParser cp) {
        ArrayList<RandomEntityRule> list = new ArrayList<RandomEntityRule>();
        int count = props.size();
        for (int i2 = 0; i2 < count; ++i2) {
            RandomEntityRule rule;
            int index = i2 + 1;
            String valTextures = props.getProperty("textures." + index);
            if (valTextures == null) {
                valTextures = props.getProperty("skins." + index);
            }
            if (valTextures == null || !(rule = new RandomEntityRule(props, pathProps, baseResLoc, index, valTextures, cp)).isValid(pathProps)) continue;
            list.add(rule);
        }
        RandomEntityRule[] rules = list.toArray(new RandomEntityRule[list.size()]);
        return rules;
    }

    public boolean isValid(String path) {
        int i2;
        if (this.resourceLocations == null && this.rules == null) {
            Config.warn("No skins specified: " + path);
            return false;
        }
        if (this.rules != null) {
            for (i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (rule.isValid(path)) continue;
                return false;
            }
        }
        if (this.resourceLocations != null) {
            for (i2 = 0; i2 < this.resourceLocations.length; ++i2) {
                jy loc = this.resourceLocations[i2];
                if (Config.hasResource(loc)) continue;
                Config.warn("Texture not found: " + loc.a());
                return false;
            }
        }
        return true;
    }

    public boolean isDefault() {
        if (this.rules != null) {
            return false;
        }
        return this.resourceLocations == null;
    }
}

