/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;

public class CustomEntityModels {
    private static boolean active = false;
    private static Map<Class, biv> originalEntityRenderMap = null;
    private static Map<Class, bhd> originalTileEntityRenderMap = null;

    public static void update() {
        Map<Class, biv> entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map<Class, bhd> tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        if (entityRenderMap == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        if (!Config.isCustomEntityModels()) {
            return;
        }
        jy[] locs = CustomEntityModels.getModelLocations();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            Class entityClass;
            jy loc = locs[i2];
            Config.dbg("CustomEntityModel: " + loc.a());
            IEntityRenderer rc = CustomEntityModels.parseEntityRender(loc);
            if (rc == null || (entityClass = rc.getEntityClass()) == null) continue;
            if (rc instanceof biv) {
                entityRenderMap.put(entityClass, (biv)rc);
            } else if (rc instanceof bhd) {
                tileEntityRenderMap.put(entityClass, (bhd)rc);
            } else {
                Config.warn("Unknown renderer type: " + rc.getClass().getName());
            }
            active = true;
        }
    }

    private static Map<Class, biv> getEntityRenderMap() {
        biu rm = ave.A().af();
        Map<Class, biv> entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<Class, biv>(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<Class, bhd> getTileEntityRenderMap() {
        Map<Class, bhd> tileEntityRenderMap = bhc.a.m;
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<Class, bhd>(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static jy[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<jy> resourceLocations = new ArrayList<jy>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            String path = prefix + name + suffix;
            jy loc = new jy(path);
            if (!Config.hasResource(loc)) continue;
            resourceLocations.add(loc);
        }
        jy[] locs = resourceLocations.toArray(new jy[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(jy location) {
        try {
            JsonObject jo = CustomEntityModelParser.loadJson(location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender(jo, location.a());
            return render;
        }
        catch (IOException e2) {
            Config.error("" + e2.getClass().getName() + ": " + e2.getMessage());
            return null;
        }
        catch (JsonParseException e3) {
            Config.error("" + ((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage());
            return null;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            return null;
        }
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender(obj, path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter(name);
        CustomEntityModels.checkNull(modelAdapter, "Entity not found: " + name);
        Class entityClass = modelAdapter.getEntityClass();
        CustomEntityModels.checkNull(entityClass, "Entity class not found: " + name);
        IEntityRenderer render = CustomEntityModels.makeEntityRender(modelAdapter, cer);
        if (render == null) {
            return null;
        }
        render.setEntityClass(entityClass);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        bbo model;
        jy textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel(modelAdapter, model, modelRenderers, mr)) {
            return null;
        }
        IEntityRenderer r2 = modelAdapter.makeEntityRender(model, shadowSize);
        if (r2 == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            r2.setLocationTextureCustom(textureLocation);
        }
        return r2;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, bbo model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr = modelRenderers[i2];
            if (CustomEntityModels.modifyModel(modelAdapter, model, cmr, mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, bbo model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        bct parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn("Model part not found: " + modelPart + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.l != null) {
                parent.l.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.m != null) {
                bct[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                List<bct> childModels = parent.m;
                Iterator<bct> it = childModels.iterator();
                while (it.hasNext()) {
                    bct mr = it.next();
                    if (setMrs.contains(mr)) continue;
                    it.remove();
                }
            }
        }
        parent.a(customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

