/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IRenderResolver;
import net.optifine.entity.model.anim.ModelVariableFloat;
import net.optifine.entity.model.anim.ModelVariableType;
import net.optifine.entity.model.anim.RenderResolverEntity;
import net.optifine.entity.model.anim.RenderResolverTileEntity;
import net.optifine.expr.IExpression;

public class ModelResolver
implements IModelResolver {
    private ModelAdapter modelAdapter;
    private bbo model;
    private CustomModelRenderer[] customModelRenderers;
    private bct thisModelRenderer;
    private bct partModelRenderer;
    private IRenderResolver renderResolver;

    public ModelResolver(ModelAdapter modelAdapter, bbo model, CustomModelRenderer[] customModelRenderers) {
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.customModelRenderers = customModelRenderers;
        Class entityClass = modelAdapter.getEntityClass();
        this.renderResolver = akw.class.isAssignableFrom(entityClass) ? new RenderResolverTileEntity() : new RenderResolverEntity();
    }

    @Override
    public IExpression getExpression(String name) {
        ModelVariableFloat mv = this.getModelVariable(name);
        if (mv != null) {
            return mv;
        }
        IExpression param = this.renderResolver.getParameter(name);
        if (param != null) {
            return param;
        }
        return null;
    }

    @Override
    public bct getModelRenderer(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(":") >= 0) {
            String[] parts = Config.tokenize(name, ":");
            bct mr = this.getModelRenderer(parts[0]);
            for (int i2 = 1; i2 < parts.length; ++i2) {
                String part = parts[i2];
                bct mrSub = mr.getChildDeep(part);
                if (mrSub == null) {
                    return null;
                }
                mr = mrSub;
            }
            return mr;
        }
        if (this.thisModelRenderer != null && name.equals("this")) {
            return this.thisModelRenderer;
        }
        if (this.partModelRenderer != null && name.equals("part")) {
            return this.partModelRenderer;
        }
        bct mrPart = this.modelAdapter.getModelRenderer(this.model, name);
        if (mrPart != null) {
            return mrPart;
        }
        for (int i3 = 0; i3 < this.customModelRenderers.length; ++i3) {
            CustomModelRenderer cmr = this.customModelRenderers[i3];
            bct mr = cmr.getModelRenderer();
            if (name.equals(mr.getId())) {
                return mr;
            }
            bct mrChild = mr.getChildDeep(name);
            if (mrChild == null) continue;
            return mrChild;
        }
        return null;
    }

    @Override
    public ModelVariableFloat getModelVariable(String name) {
        String[] parts = Config.tokenize(name, ".");
        if (parts.length != 2) {
            return null;
        }
        String modelName = parts[0];
        String varName = parts[1];
        bct mr = this.getModelRenderer(modelName);
        if (mr == null) {
            return null;
        }
        ModelVariableType varType = ModelVariableType.parse(varName);
        if (varType == null) {
            return null;
        }
        return new ModelVariableFloat(name, mr, varType);
    }

    public void setPartModelRenderer(bct partModelRenderer) {
        this.partModelRenderer = partModelRenderer;
    }

    public void setThisModelRenderer(bct thisModelRenderer) {
        this.thisModelRenderer = thisModelRenderer;
    }
}

