/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import com.logisticscraft.occlusionculling.util.Vec3d;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.access.Cullable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;

public class CullTask
implements Runnable {
    public boolean requestCull = false;
    private final OcclusionCullingInstance culling;
    private final Minecraft client = Minecraft.func_71410_x();
    private final int sleepDelay;
    private final int hitboxLimit;
    private final Set<String> unCullable;
    public long lastTime;
    private Vec3d lastPos;
    private Vec3d aabbMin;
    private Vec3d aabbMax;

    public CullTask(OcclusionCullingInstance culling, Set<String> unCullable) {
        this.sleepDelay = EntityCullingModBase.instance.config.sleepDelay;
        this.hitboxLimit = EntityCullingModBase.instance.config.hitboxLimit;
        this.lastTime = 0L;
        this.lastPos = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMin = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMax = new Vec3d(0.0, 0.0, 0.0);
        this.culling = culling;
        this.unCullable = unCullable;
    }

    @Override
    public void run() {
        while (this.client != null) {
            try {
                Thread.sleep(this.sleepDelay);
                if (!EntityCullingModBase.enabled || this.client.field_71441_e == null || this.client.field_71439_g == null || this.client.field_71439_g.field_70173_aa <= 10 || this.client.func_175606_aa() == null) continue;
                Vec3 cameraMC = null;
                cameraMC = EntityCullingModBase.instance.config.debugMode ? this.client.field_71439_g.func_174824_e(0.0f) : this.getCameraPos();
                if (!this.requestCull && cameraMC.field_72450_a == this.lastPos.x && cameraMC.field_72448_b == this.lastPos.y && cameraMC.field_72449_c == this.lastPos.z) continue;
                long start = System.currentTimeMillis();
                this.requestCull = false;
                this.lastPos.set(cameraMC.field_72450_a, cameraMC.field_72448_b, cameraMC.field_72449_c);
                Vec3d camera = this.lastPos;
                this.culling.resetCache();
                boolean noCulling = this.client.field_71439_g.func_175149_v() || this.client.field_71474_y.field_74320_O != 0;
                Iterator iterator = this.client.field_71441_e.field_147482_g.iterator();
                while (iterator.hasNext()) {
                    Cullable cullable;
                    TileEntity entry;
                    try {
                        entry = (TileEntity)iterator.next();
                    }
                    catch (NullPointerException | ConcurrentModificationException ex) {
                        break;
                    }
                    if (this.unCullable.contains(entry.func_145838_q().func_149739_a()) || (cullable = (Cullable)entry).isForcedVisible()) continue;
                    if (noCulling) {
                        cullable.setCulled(false);
                        continue;
                    }
                    BlockPos pos = entry.func_174877_v();
                    if (!(pos.func_177954_c(cameraMC.field_72450_a, cameraMC.field_72448_b, cameraMC.field_72449_c) < 4096.0)) continue;
                    this.aabbMin.set(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    this.aabbMax.set((double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 1.0);
                    boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                    cullable.setCulled(!visible);
                }
                Entity entity = null;
                Iterator iterable = this.client.field_71441_e.func_72910_y().iterator();
                while (iterable.hasNext()) {
                    Cullable cullable;
                    try {
                        entity = (Entity)iterable.next();
                    }
                    catch (NullPointerException | ConcurrentModificationException ex) {
                        break;
                    }
                    if (entity == null || !(entity instanceof Cullable) || (cullable = (Cullable)entity).isForcedVisible()) continue;
                    if (noCulling || this.isSkippableArmorstand(entity)) {
                        cullable.setCulled(false);
                        continue;
                    }
                    if (entity.func_174791_d().func_72436_e(cameraMC) > (double)(EntityCullingModBase.instance.config.tracingDistance * EntityCullingModBase.instance.config.tracingDistance)) {
                        cullable.setCulled(false);
                        continue;
                    }
                    AxisAlignedBB boundingBox = entity.func_174813_aQ();
                    if (boundingBox.field_72336_d - boundingBox.field_72340_a > (double)this.hitboxLimit || boundingBox.field_72337_e - boundingBox.field_72338_b > (double)this.hitboxLimit || boundingBox.field_72334_f - boundingBox.field_72339_c > (double)this.hitboxLimit) {
                        cullable.setCulled(false);
                        continue;
                    }
                    this.aabbMin.set(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
                    this.aabbMax.set(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                    boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                    cullable.setCulled(!visible);
                }
                this.lastTime = System.currentTimeMillis() - start;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Shutting down culling task!");
    }

    private Vec3 getCameraPos() {
        if (this.client.field_71474_y.field_74320_O == 0) {
            return this.client.func_175606_aa().func_174824_e(0.0f);
        }
        return this.client.func_175606_aa().func_174824_e(0.0f);
    }

    private boolean isSkippableArmorstand(Entity entity) {
        if (!EntityCullingModBase.instance.config.skipMarkerArmorStands) {
            return false;
        }
        return entity instanceof EntityArmorStand && ((EntityArmorStand)entity).func_181026_s();
    }
}

