/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.caelo.optifine;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moe.nea.caelo.CaeloCommand;
import moe.nea.caelo.config.CConfig;
import moe.nea.caelo.event.NeaTickEvent;
import moe.nea.caelo.event.ResourceReloadEvent;
import moe.nea.caelo.util.Histogram;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.optifine.CustomItemProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003*+,B\t\b\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR$\u0010!\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006-"}, d2={"Lmoe/nea/caelo/optifine/OptifineCustomItemCache;", "", "Lmoe/nea/caelo/event/ResourceReloadEvent;", "resourceReload", "", "onResourcePackReload", "(Lmoe/nea/caelo/event/ResourceReloadEvent;)V", "Lmoe/nea/caelo/event/NeaTickEvent;", "event", "onTick", "(Lmoe/nea/caelo/event/NeaTickEvent;)V", "Lnet/minecraft/item/ItemStack;", "itemStack", "", "type", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;", "Lnet/optifine/CustomItemProperties;", "cir", "retrieveCacheHit", "(Lnet/minecraft/item/ItemStack;ILorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;)V", "cip", "storeCustomItemProperties", "(Lnet/minecraft/item/ItemStack;ILnet/optifine/CustomItemProperties;)V", "storeNoCustomItemProperties", "(Lnet/minecraft/item/ItemStack;I)V", "Lmoe/nea/caelo/util/Histogram;", "Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheStats;", "cacheSizeHistory", "Lmoe/nea/caelo/util/Histogram;", "cacheStats", "Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheStats;", "", "Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKey;", "map", "Ljava/util/Map;", "Ljava/lang/ref/ReferenceQueue;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "<init>", "()V", "CacheKey", "CacheKeyReference", "CacheStats", "veloxcaelo"})
public final class OptifineCustomItemCache {
    @NotNull
    public static final OptifineCustomItemCache INSTANCE = new OptifineCustomItemCache();
    @NotNull
    private static final ReferenceQueue<ItemStack> referenceQueue;
    @NotNull
    private static Map<CacheKey, CustomItemProperties> map;
    @NotNull
    private static final Histogram<CacheStats> cacheSizeHistory;
    @NotNull
    private static CacheStats cacheStats;

    private OptifineCustomItemCache() {
    }

    @NotNull
    public final ReferenceQueue<ItemStack> getReferenceQueue() {
        return referenceQueue;
    }

    @SubscribeEvent
    public final void onResourcePackReload(@NotNull ResourceReloadEvent resourceReload) {
        Intrinsics.checkNotNullParameter((Object)((Object)resourceReload), (String)"resourceReload");
        map.clear();
    }

    @SubscribeEvent
    public final void onTick(@NotNull NeaTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        int removeCount = 0;
        while ((CacheKeyReference)referenceQueue.poll() != null) {
            CacheKeyReference ref;
            ++removeCount;
            map.remove(ref.getCacheKey());
        }
        cacheStats.setSize(map.size());
        cacheStats.setRemovals(removeCount);
        cacheSizeHistory.append(cacheStats);
        cacheStats = new CacheStats(0, 0, 0, 0, 0, 31, null);
    }

    @JvmStatic
    public static final void retrieveCacheHit(@NotNull ItemStack itemStack, int type, @NotNull CallbackInfoReturnable<CustomItemProperties> cir) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        if (!CConfig.INSTANCE.getConfig().optiCache.citCache) {
            return;
        }
        CacheKey key = new CacheKey(itemStack, type);
        if (!map.containsKey(key)) {
            CacheStats cacheStats = OptifineCustomItemCache.cacheStats;
            int n = cacheStats.getCacheMisses();
            cacheStats.setCacheMisses(n + 1);
            return;
        }
        CacheStats cacheStats = OptifineCustomItemCache.cacheStats;
        int n = cacheStats.getCacheHits();
        cacheStats.setCacheHits(n + 1);
        cir.setReturnValue(map.get(key));
    }

    @JvmStatic
    public static final void storeCustomItemProperties(@NotNull ItemStack itemStack, int type, @NotNull CustomItemProperties cip) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)cip, (String)"cip");
        map.put(new CacheKey(itemStack, type), cip);
        CacheStats cacheStats = OptifineCustomItemCache.cacheStats;
        int n = cacheStats.getInsertions();
        cacheStats.setInsertions(n + 1);
    }

    @JvmStatic
    public static final void storeNoCustomItemProperties(@NotNull ItemStack itemStack, int type) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        map.put(new CacheKey(itemStack, type), null);
        CacheStats cacheStats = OptifineCustomItemCache.cacheStats;
        int n = cacheStats.getInsertions();
        cacheStats.setInsertions(n + 1);
    }

    static {
        CaeloCommand.INSTANCE.subcommand("opticache", (Function1<? super String[], Unit>)((Function1)1.INSTANCE));
        referenceQueue = new ReferenceQueue();
        map = new LinkedHashMap();
        cacheSizeHistory = new Histogram(1000);
        cacheStats = new CacheStats(0, 0, 0, 0, 0, 31, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u0004\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u000b\u001a\u0004\b\f\u0010\bR\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u0018"}, d2={"Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKey;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "isPresent", "()Z", "I", "getHashCode", "Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKeyReference;", "ref", "Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKeyReference;", "getRef", "()Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKeyReference;", "type", "getType", "Lnet/minecraft/item/ItemStack;", "itemStack", "<init>", "(Lnet/minecraft/item/ItemStack;I)V", "veloxcaelo"})
    public static final class CacheKey {
        private final int type;
        private final int hashCode;
        @NotNull
        private final CacheKeyReference ref;

        public CacheKey(@NotNull ItemStack itemStack, int type) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            this.type = type;
            this.hashCode = System.identityHashCode(itemStack) * 31 + this.type;
            this.ref = new CacheKeyReference(this, itemStack);
        }

        public final int getType() {
            return this.type;
        }

        public final int getHashCode() {
            return this.hashCode;
        }

        @NotNull
        public final CacheKeyReference getRef() {
            return this.ref;
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            return this.ref.get() == ((CacheKey)other).ref.get() && this.type == ((CacheKey)other).type;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public final boolean isPresent() {
            return this.ref.get() != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKeyReference;", "Ljava/lang/ref/WeakReference;", "Lnet/minecraft/item/ItemStack;", "Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKey;", "cacheKey", "Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKey;", "getCacheKey", "()Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKey;", "itemStack", "<init>", "(Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheKey;Lnet/minecraft/item/ItemStack;)V", "veloxcaelo"})
    public static final class CacheKeyReference
    extends WeakReference<ItemStack> {
        @NotNull
        private final CacheKey cacheKey;

        public CacheKeyReference(@NotNull CacheKey cacheKey, @NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            super(itemStack, INSTANCE.getReferenceQueue());
            this.cacheKey = cacheKey;
        }

        @NotNull
        public final CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\f\u001a\u00020\u0002\u0012\b\b\u0002\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0004JB\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\t\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u0004\"\u0004\b\u001a\u0010\u001bR\"\u0010\n\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u0018\u001a\u0004\b\u001c\u0010\u0004\"\u0004\b\u001d\u0010\u001bR\"\u0010\u000b\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0018\u001a\u0004\b\u001e\u0010\u0004\"\u0004\b\u001f\u0010\u001bR\"\u0010\r\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u0018\u001a\u0004\b \u0010\u0004\"\u0004\b!\u0010\u001bR\"\u0010\f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\u0018\u001a\u0004\b\"\u0010\u0004\"\u0004\b#\u0010\u001b\u00a8\u0006&"}, d2={"Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheStats;", "", "", "component1", "()I", "component2", "component3", "component4", "component5", "cacheHits", "cacheMisses", "insertions", "size", "removals", "copy", "(IIIII)Lmoe/nea/caelo/optifine/OptifineCustomItemCache$CacheStats;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getCacheHits", "setCacheHits", "(I)V", "getCacheMisses", "setCacheMisses", "getInsertions", "setInsertions", "getRemovals", "setRemovals", "getSize", "setSize", "<init>", "(IIIII)V", "veloxcaelo"})
    public static final class CacheStats {
        private int cacheHits;
        private int cacheMisses;
        private int insertions;
        private int size;
        private int removals;

        public CacheStats(int cacheHits, int cacheMisses, int insertions, int size, int removals) {
            this.cacheHits = cacheHits;
            this.cacheMisses = cacheMisses;
            this.insertions = insertions;
            this.size = size;
            this.removals = removals;
        }

        public /* synthetic */ CacheStats(int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 1) != 0) {
                n = 0;
            }
            if ((n6 & 2) != 0) {
                n2 = 0;
            }
            if ((n6 & 4) != 0) {
                n3 = 0;
            }
            if ((n6 & 8) != 0) {
                n4 = 0;
            }
            if ((n6 & 0x10) != 0) {
                n5 = 0;
            }
            this(n, n2, n3, n4, n5);
        }

        public final int getCacheHits() {
            return this.cacheHits;
        }

        public final void setCacheHits(int n) {
            this.cacheHits = n;
        }

        public final int getCacheMisses() {
            return this.cacheMisses;
        }

        public final void setCacheMisses(int n) {
            this.cacheMisses = n;
        }

        public final int getInsertions() {
            return this.insertions;
        }

        public final void setInsertions(int n) {
            this.insertions = n;
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        public final int getRemovals() {
            return this.removals;
        }

        public final void setRemovals(int n) {
            this.removals = n;
        }

        public final int component1() {
            return this.cacheHits;
        }

        public final int component2() {
            return this.cacheMisses;
        }

        public final int component3() {
            return this.insertions;
        }

        public final int component4() {
            return this.size;
        }

        public final int component5() {
            return this.removals;
        }

        @NotNull
        public final CacheStats copy(int cacheHits, int cacheMisses, int insertions, int size, int removals) {
            return new CacheStats(cacheHits, cacheMisses, insertions, size, removals);
        }

        public static /* synthetic */ CacheStats copy$default(CacheStats cacheStats, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = cacheStats.cacheHits;
            }
            if ((n6 & 2) != 0) {
                n2 = cacheStats.cacheMisses;
            }
            if ((n6 & 4) != 0) {
                n3 = cacheStats.insertions;
            }
            if ((n6 & 8) != 0) {
                n4 = cacheStats.size;
            }
            if ((n6 & 0x10) != 0) {
                n5 = cacheStats.removals;
            }
            return cacheStats.copy(n, n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "CacheStats(cacheHits=" + this.cacheHits + ", cacheMisses=" + this.cacheMisses + ", insertions=" + this.insertions + ", size=" + this.size + ", removals=" + this.removals + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.cacheHits);
            result = result * 31 + Integer.hashCode(this.cacheMisses);
            result = result * 31 + Integer.hashCode(this.insertions);
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + Integer.hashCode(this.removals);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheStats)) {
                return false;
            }
            CacheStats cacheStats = (CacheStats)other;
            if (this.cacheHits != cacheStats.cacheHits) {
                return false;
            }
            if (this.cacheMisses != cacheStats.cacheMisses) {
                return false;
            }
            if (this.insertions != cacheStats.insertions) {
                return false;
            }
            if (this.size != cacheStats.size) {
                return false;
            }
            return this.removals == cacheStats.removals;
        }

        public CacheStats() {
            this(0, 0, 0, 0, 0, 31, null);
        }
    }
}

