/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.caelo.optifine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import moe.nea.caelo.config.CConfig;
import moe.nea.caelo.event.ResourceReloadEvent;
import moe.nea.caelo.util.MC;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b(\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013R#\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001f\u0010 \u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001f\u0010$\u001a\n \u001f*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lmoe/nea/caelo/optifine/OptifineRegexCache;", "", "", "regex", "Ljava/util/regex/Pattern;", "compilePattern", "(Ljava/lang/String;)Ljava/util/regex/Pattern;", "str", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;", "", "cir", "", "matchesRegex", "(Ljava/lang/String;Ljava/lang/String;Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;)V", "Lmoe/nea/caelo/event/ResourceReloadEvent;", "resourceReload", "onResourcePackReload", "(Lmoe/nea/caelo/event/ResourceReloadEvent;)V", "printStats", "()V", "", "cache", "Ljava/util/Map;", "getCache", "()Ljava/util/Map;", "", "illegalRegexes", "Ljava/util/Set;", "getIllegalRegexes", "()Ljava/util/Set;", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "neverRegex", "Ljava/util/regex/Pattern;", "getNeverRegex", "()Ljava/util/regex/Pattern;", "<init>", "veloxcaelo"})
public final class OptifineRegexCache {
    @NotNull
    public static final OptifineRegexCache INSTANCE = new OptifineRegexCache();
    @NotNull
    private static final Map<String, Pattern> cache = new LinkedHashMap();
    @NotNull
    private static final Set<String> illegalRegexes = new LinkedHashSet();
    private static final Logger logger = LogManager.getLogger();
    private static final Pattern neverRegex = Pattern.compile("$.");

    private OptifineRegexCache() {
    }

    @NotNull
    public final Map<String, Pattern> getCache() {
        return cache;
    }

    @NotNull
    public final Set<String> getIllegalRegexes() {
        return illegalRegexes;
    }

    public final Logger getLogger() {
        return logger;
    }

    public final Pattern getNeverRegex() {
        return neverRegex;
    }

    @SubscribeEvent
    public final void onResourcePackReload(@NotNull ResourceReloadEvent resourceReload) {
        Intrinsics.checkNotNullParameter((Object)((Object)resourceReload), (String)"resourceReload");
        cache.clear();
    }

    private final Pattern compilePattern(String regex) {
        Pattern pattern2;
        try {
            pattern2 = Pattern.compile(regex);
            Intrinsics.checkNotNull((Object)pattern2);
        }
        catch (Exception ex) {
            logger.error("Invalid regex " + regex + " in optifine resource pack", (Throwable)ex);
            illegalRegexes.add(regex);
            Pattern pattern3 = neverRegex;
            Intrinsics.checkNotNull((Object)pattern3);
            pattern2 = pattern3;
        }
        return pattern2;
    }

    public final void matchesRegex(@NotNull String str, @NotNull String regex, @NotNull CallbackInfoReturnable<Boolean> cir) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        if (!CConfig.INSTANCE.getConfig().optiCache.regexCache) {
            return;
        }
        Pattern pattern2 = cache.computeIfAbsent(regex, arg_0 -> OptifineRegexCache.matchesRegex$lambda$0((Function1)new Function1<String, Pattern>((Object)this){

            @NotNull
            public final Pattern invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OptifineRegexCache.access$compilePattern((OptifineRegexCache)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"computeIfAbsent(...)");
        Pattern pattern3 = pattern2;
        cir.setReturnValue(pattern3.matcher(str).matches());
    }

    public final void printStats() {
        MC.INSTANCE.display("Regex Stats:");
        MC.INSTANCE.display("- Cache Size: \u00a7a" + cache.size());
        if (!((Collection)illegalRegexes).isEmpty()) {
            MC.INSTANCE.display("- Illegal Regexes:");
            for (String illegalRegex : illegalRegexes) {
                MC.INSTANCE.display("  - \u00a7c" + illegalRegex);
            }
        }
    }

    private static final Pattern matchesRegex$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pattern)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Pattern access$compilePattern(OptifineRegexCache $this, String regex) {
        return $this.compilePattern(regex);
    }
}

