/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig;

import com.google.gson.annotations.Expose;
import java.awt.Color;

public class ChromaColour {
    @Expose
    float hue;
    @Expose
    float saturation;
    @Expose
    float brightness;
    @Expose
    int timeForFullRotationInMillis;
    @Expose
    int alpha;
    private static final int RADIX = 10;
    private static final int MIN_CHROMA_SECS = 1;
    private static final int MAX_CHROMA_SECS = 60;

    public Color getEffectiveColour(float offset) {
        double effectiveHue = this.timeForFullRotationInMillis > 0 ? (double)System.currentTimeMillis() / (double)this.timeForFullRotationInMillis : (double)this.hue;
        return new Color(Color.HSBtoRGB((float)((effectiveHue += (double)offset) % 1.0), this.saturation, this.brightness) | this.alpha << 24, true);
    }

    public Color getEffectiveColourWithTimeOffset(int offset) {
        double effectiveHue = this.timeForFullRotationInMillis > 0 ? (double)(System.currentTimeMillis() + (long)offset) / (double)this.timeForFullRotationInMillis : (double)this.hue;
        return new Color(Color.HSBtoRGB((float)(effectiveHue % 1.0), this.saturation, this.brightness) | this.alpha << 24, true);
    }

    public Color getEffectiveColour() {
        return this.getEffectiveColour(0.0f);
    }

    @Deprecated
    public String toLegacyString() {
        int timeInSeconds = this.timeForFullRotationInMillis / 1000;
        int namedSpeed = timeInSeconds == 0 ? 0 : (int)(255.0f - (float)(timeInSeconds - 1) * 254.0f / 59.0f);
        return ChromaColour.special(namedSpeed, this.alpha, Color.HSBtoRGB(this.hue, this.saturation, this.brightness));
    }

    @Deprecated
    public static String special(int chromaSpeed, int alpha, int rgb) {
        return ChromaColour.special(chromaSpeed, alpha, (rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
    }

    @Deprecated
    public static String special(int chromaSpeed, int alpha, int r, int g, int b) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(chromaSpeed, 10)).append(":");
        sb.append(Integer.toString(alpha, 10)).append(":");
        sb.append(Integer.toString(r, 10)).append(":");
        sb.append(Integer.toString(g, 10)).append(":");
        sb.append(Integer.toString(b, 10));
        return sb.toString();
    }

    private static int[] decompose(String csv) {
        String[] split = csv.split(":");
        int[] arr = new int[split.length];
        for (int i2 = 0; i2 < split.length; ++i2) {
            try {
                arr[i2] = Integer.parseInt(split[split.length - 1 - i2], 10);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    @Deprecated
    public static int specialToSimpleRGB(String special) {
        int[] d = ChromaColour.decompose(special);
        int r = d[2];
        int g = d[1];
        int b = d[0];
        int a = d[3];
        int chr = d[4];
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @Deprecated
    public static int getSpeed(String special) {
        return ChromaColour.decompose(special)[4];
    }

    @Deprecated
    public static float getSecondsForSpeed(int speed) {
        return (float)(255 - speed) / 254.0f * 59.0f + 1.0f;
    }

    @Deprecated
    public static int specialToChromaRGB(String special) {
        int[] d = ChromaColour.decompose(special);
        int chr = d[4];
        int a = d[3];
        int r = d[2];
        int g = d[1];
        int b = d[0];
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        if (chr > 0) {
            float seconds = ChromaColour.getSecondsForSpeed(chr);
            hsv[0] = (float)((double)hsv[0] + (double)System.currentTimeMillis() / 1000.0 / (double)seconds % 1.0);
            hsv[0] = hsv[0] % 1.0f;
            if (hsv[0] < 0.0f) {
                hsv[0] = hsv[0] + 1.0f;
            }
        }
        return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
    }

    @Deprecated
    public static int rotateHue(int argb, int degrees) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        hsv[0] = hsv[0] + (float)degrees / 360.0f;
        hsv[0] = hsv[0] % 1.0f;
        return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
    }

    @Deprecated
    public static ChromaColour forLegacyString(String stringRepresentation) {
        int[] d = ChromaColour.decompose(stringRepresentation);
        assert (d.length == 5);
        int chr = d[4];
        int a = d[3];
        int r = d[2];
        int g = d[1];
        int b = d[0];
        return ChromaColour.fromRGB(r, g, b, chr > 0 ? (int)(ChromaColour.getSecondsForSpeed(chr) * 1000.0f) : 0, a);
    }

    public static ChromaColour fromStaticRGB(int r, int g, int b, int a) {
        return ChromaColour.fromRGB(r, g, b, 0, a);
    }

    public static ChromaColour fromRGB(int r, int g, int b, int chromaSpeedMillis, int a) {
        float[] floats = Color.RGBtoHSB(r, g, b, null);
        return new ChromaColour(floats[0], floats[1], floats[2], chromaSpeedMillis, a);
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public int getTimeForFullRotationInMillis() {
        return this.timeForFullRotationInMillis;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public void setTimeForFullRotationInMillis(int timeForFullRotationInMillis) {
        this.timeForFullRotationInMillis = timeForFullRotationInMillis;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChromaColour)) {
            return false;
        }
        ChromaColour other = (ChromaColour)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getHue(), other.getHue()) != 0) {
            return false;
        }
        if (Float.compare(this.getSaturation(), other.getSaturation()) != 0) {
            return false;
        }
        if (Float.compare(this.getBrightness(), other.getBrightness()) != 0) {
            return false;
        }
        if (this.getTimeForFullRotationInMillis() != other.getTimeForFullRotationInMillis()) {
            return false;
        }
        return this.getAlpha() == other.getAlpha();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChromaColour;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getHue());
        result = result * 59 + Float.floatToIntBits(this.getSaturation());
        result = result * 59 + Float.floatToIntBits(this.getBrightness());
        result = result * 59 + this.getTimeForFullRotationInMillis();
        result = result * 59 + this.getAlpha();
        return result;
    }

    public String toString() {
        return "ChromaColour(hue=" + this.getHue() + ", saturation=" + this.getSaturation() + ", brightness=" + this.getBrightness() + ", timeForFullRotationInMillis=" + this.getTimeForFullRotationInMillis() + ", alpha=" + this.getAlpha() + ")";
    }

    public ChromaColour(float hue, float saturation, float brightness, int timeForFullRotationInMillis, int alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.timeForFullRotationInMillis = timeForFullRotationInMillis;
        this.alpha = alpha;
    }
}

