/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig;

import com.google.gson.annotations.Expose;
import moe.nea.velox.moulconfig.annotations.ConfigEditorSlider;
import moe.nea.velox.moulconfig.annotations.ConfigOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.MathHelper;

public abstract class Overlay {
    @Expose
    public float xPosition;
    @Expose
    public float yPosition;
    @Expose
    @ConfigOption(name="Scale", desc="Scale")
    @ConfigEditorSlider(minValue=0.1f, maxValue=6.0f, minStep=0.1f)
    @Deprecated
    public float scale = 1.0f;

    public float getScale() {
        return MathHelper.func_76131_a((float)this.scale, (float)0.1f, (float)6.0f);
    }

    public float getEffectiveScale() {
        return this.getScale() * (float)new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
    }

    public float getX() {
        float viewportWidth = (float)new ScaledResolution(Minecraft.func_71410_x()).func_78327_c();
        return MathHelper.func_76131_a((float)(this.xPosition * viewportWidth), (float)0.0f, (float)(viewportWidth - this.getScaledWidth()));
    }

    public float getY() {
        float viewportHeight = (float)new ScaledResolution(Minecraft.func_71410_x()).func_78324_d();
        return MathHelper.func_76131_a((float)(this.yPosition * viewportHeight), (float)0.0f, (float)(viewportHeight - this.getScaledHeight()));
    }

    public void transform() {
        GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
    }

    public float getScaledWidth() {
        return (float)this.getWidth() * this.scale;
    }

    public float getScaledHeight() {
        return (float)this.getHeight() * this.scale;
    }

    public float realWorldXToLocalX(float realWorldX) {
        return realWorldX / this.getEffectiveScale() - this.getX() / this.getScale();
    }

    public float realWorldYToLocalY(float realWorldY) {
        return realWorldY / this.getEffectiveScale() - this.getY() / this.getScale();
    }

    public int getWidth() {
        return 200;
    }

    public int getHeight() {
        return 100;
    }

    public abstract String getName();

    public boolean shouldShowInEditor() {
        return true;
    }
}

