/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.deps.libninepatch;

import moe.nea.velox.moulconfig.deps.libninepatch.NinePatch;
import moe.nea.velox.moulconfig.deps.libninepatch.TextureRegion;

@FunctionalInterface
public interface ContextualTextureRenderer<T, C> {
    public void draw(T var1, C var2, int var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10);

    default public void draw(TextureRegion<? extends T> region, C context, int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        Object texture = region.texture;
        u1 = NinePatch.lerp(u1, region.u1, region.u2);
        u2 = NinePatch.lerp(u2, region.u1, region.u2);
        v1 = NinePatch.lerp(v1, region.v1, region.v2);
        v2 = NinePatch.lerp(v2, region.v1, region.v2);
        this.draw(texture, context, x, y, width, height, u1, v1, u2, v2);
    }

    default public void drawTiled(T texture, C context, int x, int y, int regionWidth, int regionHeight, int tileWidth, int tileHeight, float u1, float v1, float u2, float v2) {
        int widthRemaining = regionWidth;
        int currentX = x;
        while (widthRemaining > 0) {
            int tw = Math.min(widthRemaining, tileWidth);
            widthRemaining -= tw;
            float tu2 = tw == tileWidth ? u2 : NinePatch.lerp((float)tw / (float)tileWidth, u1, u2);
            int heightRemaining = regionHeight;
            int currentY = y;
            while (heightRemaining > 0) {
                int th = Math.min(heightRemaining, tileHeight);
                heightRemaining -= th;
                float tv2 = th == tileHeight ? v2 : NinePatch.lerp((float)th / (float)tileHeight, v1, v2);
                this.draw(texture, context, currentX, currentY, tw, th, u1, v1, tu2, tv2);
                currentY += th;
            }
            currentX += tw;
        }
    }

    default public void drawTiled(TextureRegion<? extends T> region, C context, int x, int y, int regionWidth, int regionHeight, int tileWidth, int tileHeight, float u1, float v1, float u2, float v2) {
        Object texture = region.texture;
        u1 = NinePatch.lerp(u1, region.u1, region.u2);
        u2 = NinePatch.lerp(u2, region.u1, region.u2);
        v1 = NinePatch.lerp(v1, region.v1, region.v2);
        v2 = NinePatch.lerp(v2, region.v1, region.v2);
        this.drawTiled(texture, context, x, y, regionWidth, regionHeight, tileWidth, tileHeight, u1, v1, u2, v2);
    }
}

