/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.deps.libninepatch;

import moe.nea.velox.moulconfig.deps.libninepatch.ContextualTextureRenderer;
import moe.nea.velox.moulconfig.deps.libninepatch.NinePatch;
import moe.nea.velox.moulconfig.deps.libninepatch.TextureRegion;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface TextureRenderer<T>
extends ContextualTextureRenderer<T, Void> {
    public static final TextureRenderer<Object> STDOUT_DEBUG = (texture, x, y, width, height, u1, v1, u2, v2) -> System.out.printf("Drawing %s at (%d, %d), sized (%d, %d), UVs from (%f, %f) to (%f, %f)%n", texture, x, y, width, height, Float.valueOf(u1), Float.valueOf(v1), Float.valueOf(u2), Float.valueOf(v2));

    @SafeVarargs
    public static <T> TextureRenderer<T> compose(TextureRenderer<? super T> ... renderers) {
        return (texture, x, y, width, height, u1, v1, u2, v2) -> {
            for (TextureRenderer renderer : renderers) {
                renderer.draw(texture, x, y, width, height, u1, v1, u2, v2);
            }
        };
    }

    @Override
    default public void draw(T texture, @Nullable Void context, int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        this.draw(texture, x, y, width, height, u1, v1, u2, v2);
    }

    public void draw(T var1, int var2, int var3, int var4, int var5, float var6, float var7, float var8, float var9);

    default public void draw(TextureRegion<? extends T> region, int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        Object texture = region.texture;
        u1 = NinePatch.lerp(u1, region.u1, region.u2);
        u2 = NinePatch.lerp(u2, region.u1, region.u2);
        v1 = NinePatch.lerp(v1, region.v1, region.v2);
        v2 = NinePatch.lerp(v2, region.v1, region.v2);
        this.draw(texture, x, y, width, height, u1, v1, u2, v2);
    }
}

