/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.gui.component;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import moe.nea.velox.moulconfig.gui.GuiComponent;
import moe.nea.velox.moulconfig.gui.GuiImmediateContext;
import moe.nea.velox.moulconfig.gui.KeyboardEvent;
import moe.nea.velox.moulconfig.gui.MouseEvent;
import moe.nea.velox.moulconfig.observer.ObservableList;

public class ArrayComponent<T>
extends GuiComponent {
    public final ObservableList<T> list;
    public final Function<? super T, ? extends GuiComponent> render;
    public List<GuiComponent> guiElements;
    public IdentityHashMap<T, GuiComponent> cache = new IdentityHashMap();
    private int width;
    private int height;

    public ArrayComponent(ObservableList<T> list, Function<? super T, ? extends GuiComponent> render) {
        this.list = list;
        this.render = render;
        list.setObserver(this::reinitializeChildren);
        this.reinitializeChildren();
    }

    public void reinitializeChildren() {
        this.width = 0;
        this.height = 0;
        this.guiElements = new ArrayList<GuiComponent>();
        for (T t : this.list) {
            GuiComponent apply = this.cache.computeIfAbsent(t, this.render);
            apply.foldRecursive(null, (guiComponent, unused) -> {
                guiComponent.setContext(this.getContext());
                return null;
            });
            apply.setContext(this.getContext());
            this.width = Math.max(apply.getWidth(), this.width);
            this.height += apply.getHeight();
            this.guiElements.add(apply);
        }
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        for (GuiComponent guiElement : this.guiElements) {
            initial = visitor.apply(guiElement, (GuiComponent)initial);
        }
        return initial;
    }

    public void foldWithContext(GuiImmediateContext context, BiConsumer<GuiComponent, GuiImmediateContext> visitor) {
        this.foldChildren(0, (child, position) -> {
            visitor.accept((GuiComponent)child, context.translated(0, (int)position, child.getWidth(), child.getHeight()));
            return child.getHeight() + position;
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        this.foldWithContext(context, (child, childContext) -> {
            child.render((GuiImmediateContext)childContext);
            context.getRenderContext().translate(0.0f, child.getHeight(), 0.0f);
        });
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.mouseEvent(mouseEvent, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent keyboardEvent, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.keyboardEvent(keyboardEvent, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    public ObservableList<T> getList() {
        return this.list;
    }

    public Function<? super T, ? extends GuiComponent> getRender() {
        return this.render;
    }

    public List<GuiComponent> getGuiElements() {
        return this.guiElements;
    }

    public IdentityHashMap<T, GuiComponent> getCache() {
        return this.cache;
    }
}

