/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.gui.component;

import java.util.function.BiFunction;
import moe.nea.velox.moulconfig.gui.GuiComponent;
import moe.nea.velox.moulconfig.gui.GuiImmediateContext;
import moe.nea.velox.moulconfig.gui.KeyboardEvent;
import moe.nea.velox.moulconfig.gui.MouseEvent;

public class CenterComponent
extends GuiComponent {
    final GuiComponent child;

    public CenterComponent(GuiComponent child) {
        this.child = child;
    }

    @Override
    public int getWidth() {
        return this.child.getHeight();
    }

    @Override
    public int getHeight() {
        return this.child.getHeight();
    }

    GuiImmediateContext getChildContext(GuiImmediateContext context) {
        return context.translated(this.getChildOffsetX(context), this.getChildOffsetY(context), this.child.getWidth(), this.child.getHeight());
    }

    public int getChildOffsetX(GuiImmediateContext context) {
        return context.getWidth() / 2 - this.child.getWidth() / 2;
    }

    public int getChildOffsetY(GuiImmediateContext context) {
        return context.getHeight() / 2 - this.child.getHeight() / 2;
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        return visitor.apply(this.child, (GuiComponent)initial);
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        context.getRenderContext().translate(this.getChildOffsetX(context), this.getChildOffsetY(context), 0.0f);
        this.child.render(this.getChildContext(context));
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        return this.child.keyboardEvent(event, this.getChildContext(context));
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        return this.child.mouseEvent(mouseEvent, this.getChildContext(context));
    }
}

