/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.gui.component;

import java.util.function.BiFunction;
import moe.nea.velox.moulconfig.gui.GuiComponent;
import moe.nea.velox.moulconfig.gui.GuiImmediateContext;
import moe.nea.velox.moulconfig.gui.KeyboardEvent;
import moe.nea.velox.moulconfig.gui.MouseEvent;

public class ScrollPanelComponent
extends GuiComponent {
    final int width;
    final int height;
    final GuiComponent child;
    int scrollOffset;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        return visitor.apply(this.child, (GuiComponent)initial);
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        int x = context.getRenderOffsetX();
        int y = context.getRenderOffsetY();
        context.getRenderContext().pushScissor(x, y, x + this.width, y + this.height);
        context.getRenderContext().translate(0.0f, -this.scrollOffset, 0.0f);
        this.child.render(context.translatedNonRendering(0, -this.scrollOffset, this.width, this.height));
        context.getRenderContext().popScissor();
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        return this.child.keyboardEvent(event, context.translatedNonRendering(0, -this.scrollOffset, this.width, this.height));
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        if (this.child.mouseEvent(mouseEvent, context.translatedNonRendering(0, -this.scrollOffset, this.width, this.height))) {
            return true;
        }
        if (context.isHovered() && mouseEvent instanceof MouseEvent.Scroll) {
            this.scrollOffset = (int)Math.max(0.0f, Math.min((float)this.scrollOffset - ((MouseEvent.Scroll)mouseEvent).getDWheel(), (float)(this.child.getHeight() - this.height)));
            return true;
        }
        return false;
    }

    public ScrollPanelComponent(int width, int height, GuiComponent child) {
        this.width = width;
        this.height = height;
        this.child = child;
    }
}

