/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.gui.component;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moe.nea.velox.moulconfig.common.IFontRenderer;
import moe.nea.velox.moulconfig.common.IMinecraft;
import moe.nea.velox.moulconfig.common.KeyboardConstants;
import moe.nea.velox.moulconfig.gui.GuiComponent;
import moe.nea.velox.moulconfig.gui.GuiImmediateContext;
import moe.nea.velox.moulconfig.gui.KeyboardEvent;
import moe.nea.velox.moulconfig.gui.MouseEvent;
import moe.nea.velox.moulconfig.internal.ClipboardUtils;
import moe.nea.velox.moulconfig.observer.GetSetter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 H2\u00020\u0001:\u0001HBA\u0012\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0@\u0012\u0006\u0010E\u001a\u00020\u0005\u0012\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u00020\u001001\u0012\b\b\u0002\u0010=\u001a\u00020\b\u0012\b\b\u0002\u00107\u001a\u000206\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0007J\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u001f\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010#\u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b#\u0010$J'\u0010#\u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b#\u0010&J\u000f\u0010'\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b'\u0010\u0004J\u001f\u0010)\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b+\u0010\u0004J\u0015\u0010-\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\b\u00a2\u0006\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001d\u00102\u001a\b\u0012\u0004\u0012\u00020\u0010018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0017\u00107\u001a\u0002068\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0016\u0010;\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00100R\u0016\u0010<\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u00100R\u0017\u0010=\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010\nR\u001d\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0@8\u0006\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010DR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010>R\u0014\u0010E\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u00100\u00a8\u0006I"}, d2={"Lmoe/nea/velox/moulconfig/gui/component/TextFieldComponent;", "Lmoe/nea/velox/moulconfig/gui/GuiComponent;", "", "checkScrollOffset", "()V", "", "getHeight", "()I", "", "getSelection", "()Ljava/lang/String;", "getWidth", "Lmoe/nea/velox/moulconfig/gui/KeyboardEvent;", "event", "Lmoe/nea/velox/moulconfig/gui/GuiImmediateContext;", "context", "", "keyboardEvent", "(Lio/github/notenoughupdates/moulconfig/gui/KeyboardEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lmoe/nea/velox/moulconfig/gui/MouseEvent;", "mouseEvent", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "i", "onDirectionalKey", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;I)V", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "renderBox", "renderCursor", "renderSelection", "visibleText", "renderText", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;Ljava/lang/String;)V", "str", "startIndex", "safeSubString", "(Ljava/lang/String;I)Ljava/lang/String;", "endIndex", "(Ljava/lang/String;II)Ljava/lang/String;", "scrollCursorIntoView", "skipWords", "skipCharacters", "(ZI)I", "validateCursor", "s", "writeText", "(Ljava/lang/String;)V", "cursor", "I", "Ljava/util/function/Supplier;", "editable", "Ljava/util/function/Supplier;", "getEditable", "()Ljava/util/function/Supplier;", "Lmoe/nea/velox/moulconfig/common/IFontRenderer;", "font", "Lmoe/nea/velox/moulconfig/common/IFontRenderer;", "getFont", "()Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;", "scrollOffset", "selection", "suggestion", "Ljava/lang/String;", "getSuggestion", "Lmoe/nea/velox/moulconfig/observer/GetSetter;", "text", "Lmoe/nea/velox/moulconfig/observer/GetSetter;", "getText", "()Lio/github/notenoughupdates/moulconfig/observer/GetSetter;", "width", "<init>", "(Lio/github/notenoughupdates/moulconfig/observer/GetSetter;ILjava/util/function/Supplier;Ljava/lang/String;Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;)V", "Companion", "common"})
public class TextFieldComponent
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GetSetter<String> text;
    private final int width;
    @NotNull
    private final Supplier<Boolean> editable;
    @NotNull
    private final String suggestion;
    @NotNull
    private final IFontRenderer font;
    private int cursor;
    private int selection;
    private int scrollOffset;
    @Nullable
    private String visibleText;
    private static final int TEXT_PADDING_X = 2;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int BORDER_COLOR_SELECTED = -96;
    private static final int BORDER_COLOR_UNSELECTED = -6250336;
    private static final int ENABLED_COLOR = -2039584;
    private static final int SUGGESTION_COLOR = -8355712;
    private static final int DISABLED_COLOR = -9408400;
    private static final int CURSOR_COLOR = -3092272;
    private static final int TEXT_PADDING_Y = 2;

    public TextFieldComponent(@NotNull GetSetter<String> text, int width, @NotNull Supplier<Boolean> editable, @NotNull String suggestion, @NotNull IFontRenderer font) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Intrinsics.checkNotNullParameter(editable, (String)"editable");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.text = text;
        this.width = width;
        this.editable = editable;
        this.suggestion = suggestion;
        this.font = font;
        this.selection = -1;
    }

    public /* synthetic */ TextFieldComponent(GetSetter getSetter, int n, Supplier supplier, String string, IFontRenderer iFontRenderer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            GetSetter<Boolean> getSetter2 = GetSetter.constant(true);
            Intrinsics.checkNotNullExpressionValue(getSetter2, (String)"constant(true)");
            supplier = getSetter2;
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            iFontRenderer = IMinecraft.instance.getDefaultFontRenderer();
        }
        this(getSetter, n, supplier, string, iFontRenderer);
    }

    @NotNull
    public final GetSetter<String> getText() {
        return this.text;
    }

    @NotNull
    public final Supplier<Boolean> getEditable() {
        return this.editable;
    }

    @NotNull
    public final String getSuggestion() {
        return this.suggestion;
    }

    @NotNull
    public final IFontRenderer getFont() {
        return this.font;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    public void scrollCursorIntoView() {
        this.validateCursor();
        if (this.scrollOffset > this.cursor) {
            this.scrollOffset = this.cursor;
        }
        if (this.scrollOffset < this.cursor) {
            String string = this.text.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.get()");
            if (this.font.trimStringToWidth(this.safeSubString(string, this.scrollOffset), this.width - 4).length() + this.scrollOffset < this.cursor) {
                this.scrollOffset = this.cursor;
            }
        }
        this.checkScrollOffset();
    }

    public void checkScrollOffset() {
        String text = this.text.get();
        int n = text.length();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        int rightMostScrollOffset = n - this.font.trimStringToWidth(text, this.width - 4, true).length();
        this.scrollOffset = Math.max(0, Math.min(rightMostScrollOffset, this.scrollOffset));
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.validateCursor();
        this.checkScrollOffset();
        String string = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.get()");
        this.visibleText = this.font.trimStringToWidth(this.safeSubString(string, this.scrollOffset), this.width - 4);
        this.renderBox(context);
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        this.renderText(context, string2);
        String string3 = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text.get()");
        if (((CharSequence)string3).length() == 0 && !this.isFocused()) {
            context.getRenderContext().drawString(this.font, this.suggestion, 2, 2, -8355712, false);
        }
        if (this.isFocused()) {
            this.renderCursor(context);
        }
        this.renderSelection(context);
    }

    public void validateCursor() {
        this.cursor = Math.max(0, Math.min(this.text.get().length(), this.cursor));
    }

    private final void renderSelection(GuiImmediateContext context) {
        int right;
        int left;
        block5: {
            block4: {
                if (this.selection == this.cursor || this.selection == -1) {
                    return;
                }
                left = Math.min(this.cursor, this.selection);
                right = Math.max(this.cursor, this.selection);
                if (right < this.scrollOffset) break block4;
                String string = this.visibleText;
                Intrinsics.checkNotNull((Object)string);
                if (left <= this.scrollOffset + string.length()) break block5;
            }
            return;
        }
        int normalizedLeft = Math.max(this.scrollOffset, left) - this.scrollOffset;
        String string = this.visibleText;
        Intrinsics.checkNotNull((Object)string);
        int normalizedRight = Math.min(this.scrollOffset + string.length(), right) - this.scrollOffset;
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        int leftPos = this.font.getStringWidth(this.safeSubString(string2, 0, normalizedLeft));
        String string3 = this.visibleText;
        Intrinsics.checkNotNull((Object)string3);
        int rightPos = leftPos + this.font.getStringWidth(this.safeSubString(string3, normalizedLeft, normalizedRight));
        context.getRenderContext().invertedRect(2 + leftPos, 2.0f, 2 + rightPos, this.getHeight() - 2);
    }

    private final void renderCursor(GuiImmediateContext context) {
        if (System.currentTimeMillis() / (long)1000 % (long)2 == 0L) {
            return;
        }
        if (this.cursor < this.scrollOffset) {
            return;
        }
        String string = this.visibleText;
        Intrinsics.checkNotNull((Object)string);
        if (this.cursor > this.scrollOffset + string.length()) {
            return;
        }
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        int cursorOffset = this.font.getStringWidth(this.safeSubString(string2, 0, this.cursor - this.scrollOffset));
        context.getRenderContext().drawColoredRect(2 + cursorOffset, 2.0f, 2 + cursorOffset + 1, this.getHeight() - 2, -3092272);
    }

    private final void renderText(GuiImmediateContext context, String visibleText) {
        Boolean bl = this.editable.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"editable.get()");
        int textColor = bl != false ? -2039584 : -9408400;
        context.getRenderContext().drawString(this.font, visibleText, 2, 2, textColor, true);
    }

    private final void renderBox(GuiImmediateContext context) {
        int borderColor = this.isFocused() ? -96 : -6250336;
        context.getRenderContext().drawColoredRect(0.0f, 0.0f, this.width, this.getHeight(), borderColor);
        context.getRenderContext().drawColoredRect(1.0f, 1.0f, this.width - 1, this.getHeight() - 1, -16777216);
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.editable.get().booleanValue()) {
            return false;
        }
        if (!this.isFocused()) {
            return false;
        }
        if (event instanceof KeyboardEvent.KeyPressed && ((KeyboardEvent.KeyPressed)event).getPressed()) {
            int n = ((KeyboardEvent.KeyPressed)event).getKeycode();
            if (n == KeyboardConstants.INSTANCE.getLeft()) {
                this.onDirectionalKey(context, -1);
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getRight()) {
                this.onDirectionalKey(context, 1);
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getHome() ? true : n == KeyboardConstants.INSTANCE.getUp()) {
                if (context.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = 0;
                this.scrollCursorIntoView();
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getDown() ? true : n == KeyboardConstants.INSTANCE.getEnd()) {
                if (context.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = this.text.get().length();
                this.scrollCursorIntoView();
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getBackSpace()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context.getRenderContext().isCtrlDown(), -1);
                }
                this.writeText("");
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getDelete()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context.getRenderContext().isCtrlDown(), 1);
                }
                this.writeText("");
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyC()) {
                if (context.getRenderContext().isCtrlDown()) {
                    ClipboardUtils.copyToClipboard(this.getSelection());
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyX()) {
                if (context.getRenderContext().isCtrlDown()) {
                    ClipboardUtils.copyToClipboard(this.getSelection());
                    this.writeText("");
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyV()) {
                if (context.getRenderContext().isCtrlDown()) {
                    String string = ClipboardUtils.getClipboardContent();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClipboardContent()");
                    this.writeText(string);
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyA()) {
                if (context.getRenderContext().isCtrlDown()) {
                    this.cursor = this.text.get().length();
                    this.selection = 0;
                    this.scrollCursorIntoView();
                    return true;
                }
                return false;
            }
            return false;
        }
        if (event instanceof KeyboardEvent.CharTyped) {
            char it = ((KeyboardEvent.CharTyped)event).getChar();
            boolean anyWritten = false;
            if (Intrinsics.compare((int)it, (int)32) >= 0 && it != '\u00a7' && it != '\u007f') {
                char c = it;
                String string = "";
                this.writeText(c + string);
                anyWritten = true;
            }
            return anyWritten;
        }
        return false;
    }

    private final String getSelection() {
        if (this.selection == -1) {
            return "";
        }
        int l = Math.min(this.cursor, this.selection);
        int r = Math.max(this.cursor, this.selection);
        String string = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.get()");
        return this.safeSubString(string, l, r);
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.mouseEvent(mouseEvent, context);
        if (context.isHovered() && mouseEvent instanceof MouseEvent.Click && ((MouseEvent.Click)mouseEvent).getMouseState() && ((MouseEvent.Click)mouseEvent).getMouseButton() == 0) {
            this.requestFocus();
            return true;
        }
        return false;
    }

    private final String safeSubString(String str, int startIndex) {
        String string = str.substring(Math.min(startIndex, str.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    private final String safeSubString(String str, int startIndex, int endIndex) {
        String string = str.substring(Math.min(startIndex, str.length()), Math.min(Math.max(startIndex, endIndex), str.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final void writeText(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String t = this.text.get();
        if (this.selection == -1) {
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, this.cursor)).append(s).append(this.safeSubString(t, this.cursor)).toString());
            this.cursor += s.length();
        } else {
            int l = Math.min(this.cursor, this.selection);
            int r = Math.max(this.cursor, this.selection);
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, l)).append(s).append(this.safeSubString(t, r)).toString());
            this.cursor = l + s.length();
            this.selection = -1;
        }
        this.scrollCursorIntoView();
    }

    public void onDirectionalKey(@NotNull GuiImmediateContext context, int i2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getRenderContext().isShiftDown()) {
            if (this.selection == -1) {
                this.selection = this.cursor;
            }
            this.cursor = this.skipCharacters(context.getRenderContext().isCtrlDown(), i2);
        } else if (this.selection != -1) {
            this.cursor = i2 < 0 ? Math.min(this.cursor, this.selection) : Math.max(this.cursor, this.selection);
            this.selection = -1;
        } else {
            this.cursor = this.skipCharacters(context.getRenderContext().isCtrlDown(), i2);
        }
        this.scrollCursorIntoView();
    }

    private final int skipCharacters(boolean skipWords, int i2) {
        if (i2 != -1 && i2 != 1) {
            return this.cursor;
        }
        int position = this.cursor;
        do {
            if ((position += i2) < 0) {
                return 0;
            }
            if (position > this.text.get().length()) {
                return this.text.get().length();
            }
            if (skipWords) continue;
            return position;
        } while (position >= this.text.get().length() || !Character.isWhitespace(this.text.get().charAt(position)));
        return position;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004R\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0004R\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0004R\u0014\u0010\f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lmoe/nea/velox/moulconfig/gui/component/TextFieldComponent$Companion;", "", "", "BACKGROUND_COLOR", "I", "BORDER_COLOR_SELECTED", "BORDER_COLOR_UNSELECTED", "CURSOR_COLOR", "DISABLED_COLOR", "ENABLED_COLOR", "SUGGESTION_COLOR", "TEXT_PADDING_X", "TEXT_PADDING_Y", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

