/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.gui.editors;

import java.util.List;
import moe.nea.velox.moulconfig.DescriptionRendereringBehaviour;
import moe.nea.velox.moulconfig.common.IFontRenderer;
import moe.nea.velox.moulconfig.common.IMinecraft;
import moe.nea.velox.moulconfig.gui.GuiComponent;
import moe.nea.velox.moulconfig.gui.GuiContext;
import moe.nea.velox.moulconfig.gui.GuiImmediateContext;
import moe.nea.velox.moulconfig.gui.GuiOptionEditor;
import moe.nea.velox.moulconfig.gui.KeyboardEvent;
import moe.nea.velox.moulconfig.gui.MouseEvent;
import moe.nea.velox.moulconfig.gui.component.CenterComponent;
import moe.nea.velox.moulconfig.gui.component.PanelComponent;
import moe.nea.velox.moulconfig.internal.ForgeRenderContext;
import moe.nea.velox.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class ComponentEditor
extends GuiOptionEditor {
    @Nullable
    private GuiComponent overlay;
    private int overlayX;
    private int overlayY;
    private int lastRenderX;
    private int lastRenderY;
    private int lastRenderWidth;
    private int lastRenderHeight;

    protected ComponentEditor(ProcessedOption option) {
        super(option);
    }

    @NotNull
    public abstract GuiComponent getDelegate();

    public void closeOverlay() {
        this.overlay = null;
    }

    public void openOverlay(GuiComponent overlay, int overlayX, int overlayY) {
        this.overlay = overlay;
        this.overlayX = overlayX;
        this.overlayY = overlayY;
    }

    @Nullable
    public GuiComponent getOverlayDelegate() {
        return this.overlay;
    }

    public GuiImmediateContext getImmContext(int x, int y, int width, int height) {
        IMinecraft instance = IMinecraft.instance;
        return new GuiImmediateContext(new ForgeRenderContext(), x, y, width, height, instance.getMouseX() - x, instance.getMouseY() - y, instance.getMouseX(), instance.getMouseY(), (float)instance.getMouseXHF() - (float)x, (float)instance.getMouseYHF() - (float)y);
    }

    protected GuiComponent wrapComponent(GuiComponent component) {
        return new EditorComponentWrapper(new CenterComponent(component));
    }

    @Override
    public int getHeight() {
        return Math.max(this.getDelegate().getHeight(), super.getHeight());
    }

    @Override
    public final boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        if (Mouse.getEventButton() == -1) {
            return this.getDelegate().mouseEvent(new MouseEvent.Move(Mouse.getEventDX(), Mouse.getEventDY()), this.getImmContext(x, y, width, this.getHeight()));
        }
        return this.getDelegate().mouseEvent(new MouseEvent.Click(Mouse.getEventButton(), Mouse.getEventButtonState()), this.getImmContext(x, y, width, this.getHeight()));
    }

    @Override
    public final boolean keyboardInput() {
        GuiImmediateContext ctx = this.getImmContext(this.lastRenderX, this.lastRenderY, this.lastRenderWidth, this.lastRenderHeight);
        GuiComponent overlay = this.getOverlayDelegate();
        if (overlay != null) {
            overlay.foldRecursive(null, (comp, _void) -> {
                comp.setContext(this.getDelegate().getContext());
                return _void;
            });
            if (Keyboard.getEventKeyState() && overlay.keyboardEvent(new KeyboardEvent.CharTyped(Keyboard.getEventCharacter()), ctx)) {
                return true;
            }
            if (overlay.keyboardEvent(new KeyboardEvent.KeyPressed(Keyboard.getEventKey(), Keyboard.getEventKeyState()), ctx)) {
                return true;
            }
        }
        if (Keyboard.getEventKeyState() && this.getDelegate().keyboardEvent(new KeyboardEvent.CharTyped(Keyboard.getEventCharacter()), ctx)) {
            return true;
        }
        return this.getDelegate().keyboardEvent(new KeyboardEvent.KeyPressed(Keyboard.getEventKey(), Keyboard.getEventKeyState()), ctx);
    }

    @Override
    public void setGuiContext(GuiContext guiContext) {
        this.getDelegate().setContext(guiContext);
    }

    @Override
    public final void render(int x, int y, int width) {
        this.lastRenderX = x;
        this.lastRenderY = y;
        this.lastRenderWidth = width;
        this.lastRenderHeight = this.getHeight();
        GuiImmediateContext context = this.getImmContext(x, y, width, this.getHeight());
        context.getRenderContext().pushMatrix();
        context.getRenderContext().translate(context.getRenderOffsetX(), context.getRenderOffsetY(), 0.0f);
        this.getDelegate().render(context);
        context.getRenderContext().popMatrix();
    }

    @Override
    public final boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY) {
        if (this.overlay == null) {
            return false;
        }
        this.overlay.foldRecursive(null, (comp, _void) -> {
            comp.setContext(this.getDelegate().getContext());
            return _void;
        });
        if (Mouse.getEventButton() == -1) {
            return this.overlay.mouseEvent(new MouseEvent.Move(Mouse.getEventDX(), Mouse.getEventDY()), this.getImmContext(this.overlayX, this.overlayY, this.overlay.getWidth(), this.overlay.getHeight()));
        }
        return this.overlay.mouseEvent(new MouseEvent.Click(Mouse.getEventButton(), Mouse.getEventButtonState()), this.getImmContext(this.overlayX, this.overlayY, this.overlay.getWidth(), this.overlay.getHeight()));
    }

    @Override
    public final void renderOverlay(int x, int y, int width) {
        if (this.overlay == null) {
            return;
        }
        this.overlay.foldRecursive(null, (comp, _void) -> {
            comp.setContext(this.getDelegate().getContext());
            return _void;
        });
        GuiImmediateContext ctx = this.getImmContext(this.overlayX, this.overlayY, this.overlay.getWidth(), this.overlay.getHeight());
        ctx.getRenderContext().translate(this.overlayX, this.overlayY, 0.0f);
        this.overlay.render(ctx);
    }

    public int getOverlayX() {
        return this.overlayX;
    }

    public int getOverlayY() {
        return this.overlayY;
    }

    public class EditorComponentWrapper
    extends PanelComponent {
        public EditorComponentWrapper(GuiComponent component) {
            super(component);
        }

        @Override
        public int getWidth() {
            return super.getWidth() + 150;
        }

        @Override
        public int getHeight() {
            if (((ComponentEditor)ComponentEditor.this).option.config.getDescriptionBehaviour(ComponentEditor.this.option) != DescriptionRendereringBehaviour.EXPAND_PANEL) {
                return super.getHeight();
            }
            IFontRenderer fr = IMinecraft.instance.getDefaultFontRenderer();
            return Math.max(45, fr.splitText(((ComponentEditor)ComponentEditor.this).option.desc, 156).size() * (fr.getHeight() + 1) + 10);
        }

        @Override
        protected GuiImmediateContext getChildContext(GuiImmediateContext context) {
            return context.translated(5, 13, context.getWidth() / 3 - 10, context.getHeight() - 13);
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            context.getRenderContext().drawDarkRect(0, 0, context.getWidth(), context.getHeight() - 2);
            this.renderTitle(context);
            this.renderDescription(context);
            this.renderElement(context);
        }

        protected void renderElement(@NotNull GuiImmediateContext context) {
            context.getRenderContext().pushMatrix();
            context.getRenderContext().translate(5.0f, 13.0f, 0.0f);
            this.getElement().render(this.getChildContext(context));
            context.getRenderContext().popMatrix();
        }

        protected void renderTitle(@NotNull GuiImmediateContext context) {
            int width = context.getWidth();
            IMinecraft minecraft = context.getRenderContext().getMinecraft();
            IFontRenderer fr = minecraft.getDefaultFontRenderer();
            context.getRenderContext().drawStringCenteredScaledMaxWidth(((ComponentEditor)ComponentEditor.this).option.name, fr, width / 6, 13.0f, true, width / 3 - 10, 0xC0C0C0);
        }

        protected void renderDescription(@NotNull GuiImmediateContext context) {
            List<String> lines;
            int width = context.getWidth();
            IMinecraft minecraft = context.getRenderContext().getMinecraft();
            IFontRenderer fr = minecraft.getDefaultFontRenderer();
            float scale = 1.0f;
            while (!((float)(lines = fr.splitText(((ComponentEditor)ComponentEditor.this).option.desc, (int)((float)(width * 2 / 3) / scale - 10.0f))).size() * scale * (float)(fr.getHeight() + 1) + 10.0f < (float)context.getHeight()) && !((scale -= 0.125f) < 0.0625f)) {
            }
            context.getRenderContext().pushMatrix();
            context.getRenderContext().translate(5 + width / 3, 5.0f, 0.0f);
            context.getRenderContext().scale(scale, scale, 1.0f);
            context.getRenderContext().translate(0.0f, ((float)(context.getHeight() - 10) - (float)((fr.getHeight() + 1) * (lines.size() - 1)) * scale) / 2.0f, 0.0f);
            for (String line : lines) {
                context.getRenderContext().drawString(fr, line, 0, 0, 0xC0C0C0, false);
                context.getRenderContext().translate(0.0f, fr.getHeight() + 1, 0.0f);
            }
            context.getRenderContext().popMatrix();
        }
    }
}

