/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.gui.editors;

import java.util.Locale;
import moe.nea.velox.moulconfig.Config;
import moe.nea.velox.moulconfig.GuiTextures;
import moe.nea.velox.moulconfig.common.IMinecraft;
import moe.nea.velox.moulconfig.gui.GuiComponent;
import moe.nea.velox.moulconfig.gui.GuiImmediateContext;
import moe.nea.velox.moulconfig.gui.MouseEvent;
import moe.nea.velox.moulconfig.gui.editors.ComponentEditor;
import moe.nea.velox.moulconfig.processor.ProcessedOption;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorButton
extends ComponentEditor {
    private final int runnableId;
    private String buttonText;
    private final Config config;
    private boolean isUsingRunnable;
    private final GuiComponent delegate = this.wrapComponent(new GuiComponent(){

        @Override
        public int getWidth() {
            return 48;
        }

        @Override
        public int getHeight() {
            return 16;
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IMinecraft.instance.bindTexture(GuiTextures.BUTTON);
            context.getRenderContext().drawTexturedRect(0.0f, 0.0f, context.getWidth(), context.getHeight());
            context.getRenderContext().drawStringCenteredScaledMaxWidth(GuiOptionEditorButton.this.buttonText, context.getRenderContext().getMinecraft().getDefaultFontRenderer(), (float)context.getWidth() / 2.0f, (float)context.getHeight() / 2.0f, false, context.getWidth() - 4, -13619152);
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
            MouseEvent.Click click;
            if (mouseEvent instanceof MouseEvent.Click && (click = (MouseEvent.Click)mouseEvent).getMouseState() && context.isHovered() && click.getMouseButton() == 0) {
                GuiOptionEditorButton.this.onClick();
                return true;
            }
            return super.mouseEvent(mouseEvent, context);
        }
    });

    public GuiOptionEditorButton(ProcessedOption option, int runnableId, String buttonText, Config config) {
        super(option);
        this.runnableId = runnableId;
        this.config = config;
        this.buttonText = buttonText;
        boolean bl = this.isUsingRunnable = option.getType() == Runnable.class;
        if (this.buttonText == null) {
            this.buttonText = "";
        }
    }

    public void onClick() {
        if (this.isUsingRunnable) {
            ((Runnable)this.option.get()).run();
        } else {
            this.config.executeRunnable(this.runnableId);
        }
    }

    @Override
    public boolean fulfillsSearch(String word) {
        return super.fulfillsSearch(word) || this.buttonText.toLowerCase(Locale.ROOT).contains(word);
    }

    @Override
    public GuiComponent getDelegate() {
        return this.delegate;
    }
}

