/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.internal;

import java.lang.reflect.Field;
import moe.nea.velox.moulconfig.gui.GuiOptionEditor;

public class ContextAware {
    public static <T> T wrapErrorWithContext(GuiOptionEditor editor, ContextAwareRunnable<T> runnable) {
        try {
            return runnable.run();
        }
        catch (Exception e) {
            throw new ContextualException(e, editor != null && editor.getOption() != null ? editor.getOption().field : null);
        }
    }

    public static <T> T wrapErrorWithContext(Field field, ContextAwareRunnable<T> runnable) {
        try {
            return runnable.run();
        }
        catch (Exception e) {
            throw new ContextualException(e, field);
        }
    }

    public static class ContextualException
    extends RuntimeException {
        public ContextualException(Exception exception, Field field) {
            super("Editor at field " + (field == null ? "<null>" : field) + " crashed: " + exception.getMessage(), exception);
        }
    }

    @FunctionalInterface
    public static interface ContextAwareRunnable<T> {
        public T run() throws Exception;
    }
}

