/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.internal;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;

public class StringUtils {
    private static long startTime = 0L;
    private static final EnumChatFormatting[] rainbow = new EnumChatFormatting[]{EnumChatFormatting.RED, EnumChatFormatting.GOLD, EnumChatFormatting.YELLOW, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.DARK_PURPLE};
    private static Pattern CHROMA_REPLACE_PATTERN = Pattern.compile("\u00a7(.)([^\u00a7]+)");

    public static String cleanColour(String before) {
        return before.replaceAll("\u00a7.", "");
    }

    public static String chromaString(String str, String styles, boolean bold) {
        str = StringUtils.cleanColour(str);
        long currentTimeMillis = System.currentTimeMillis();
        if (startTime == 0L) {
            startTime = currentTimeMillis;
        }
        StringBuilder rainbowText = new StringBuilder();
        int len = 0;
        for (char c : str.toCharArray()) {
            int index = (int)((float)len / 12.0f - (float)((currentTimeMillis - startTime) / 500L)) % rainbow.length;
            len += Minecraft.func_71410_x().field_71466_p.func_78263_a(c);
            if (bold) {
                ++len;
            }
            if (index < 0) {
                index += rainbow.length;
            }
            rainbowText.append(rainbow[index]);
            if (bold) {
                rainbowText.append(EnumChatFormatting.BOLD);
            }
            rainbowText.append(c);
        }
        return rainbowText.toString();
    }

    public static String chromaStringByColourCode(String str) {
        Matcher matcher = CHROMA_REPLACE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean isBold = false;
        String styles = "";
        while (matcher.find()) {
            String format = matcher.group(1).intern().toLowerCase(Locale.ENGLISH);
            String replacement = matcher.group(2);
            if ("z".equals(format)) {
                replacement = StringUtils.chromaString(replacement, styles, isBold);
            } else if ("l".equals(format)) {
                isBold = true;
            } else if ("0123456789abcdef".contains(format)) {
                styles = "";
                isBold = false;
            } else {
                styles = styles + "\u00a7" + format;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

