/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.managed;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import moe.nea.velox.moulconfig.managed.DataMapper;
import moe.nea.velox.moulconfig.managed.ManagedDataFile;
import moe.nea.velox.moulconfig.managed.ManagedDataFileBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 -*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001-B\u0017\b\u0016\u0012\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000(\u00a2\u0006\u0004\b*\u0010+B\u00ab\u0001\b\u0000\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u0012\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"\u0012\u001c\u0010 \u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001d\u0012\u001c\u0010'\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001d\u0012\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r\u0012\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r\u0012\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r\u00a2\u0006\u0004\b*\u0010,J!\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\u000bR \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000fR \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0013\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\u00028\u00008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR*\u0010 \u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R*\u0010'\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010!\u00a8\u0006."}, d2={"Lmoe/nea/velox/moulconfig/managed/ManagedDataFile;", "T", "", "", "identifier", "Ljava/io/File;", "directory", "createUniqueExtraFile", "(Ljava/lang/String;Ljava/io/File;)Ljava/io/File;", "", "reloadFromFile", "()V", "saveToFile", "Ljava/util/function/Consumer;", "afterLoad", "Ljava/util/function/Consumer;", "afterSave", "beforeLoad", "beforeSave", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "instance", "Ljava/lang/Object;", "getInstance", "()Ljava/lang/Object;", "setInstance", "(Ljava/lang/Object;)V", "Ljava/util/function/BiConsumer;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loadFailed", "Ljava/util/function/BiConsumer;", "Lmoe/nea/velox/moulconfig/managed/DataMapper;", "mapper", "Lmoe/nea/velox/moulconfig/managed/DataMapper;", "getMapper", "()Lio/github/notenoughupdates/moulconfig/managed/DataMapper;", "saveFailed", "Lmoe/nea/velox/moulconfig/managed/ManagedDataFileBuilder;", "builder", "<init>", "(Lio/github/notenoughupdates/moulconfig/managed/ManagedDataFileBuilder;)V", "(Ljava/io/File;Lio/github/notenoughupdates/moulconfig/managed/DataMapper;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;Ljava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Consumer;)V", "Companion", "common"})
public class ManagedDataFile<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final DataMapper<T> mapper;
    @NotNull
    private final BiConsumer<ManagedDataFile<T>, Exception> loadFailed;
    @NotNull
    private final BiConsumer<ManagedDataFile<T>, Exception> saveFailed;
    @NotNull
    private final Consumer<ManagedDataFile<T>> beforeLoad;
    @NotNull
    private final Consumer<ManagedDataFile<T>> afterLoad;
    @NotNull
    private final Consumer<ManagedDataFile<T>> beforeSave;
    @NotNull
    private final Consumer<ManagedDataFile<T>> afterSave;
    private T instance;

    public ManagedDataFile(@NotNull File file, @NotNull DataMapper<T> mapper, @NotNull BiConsumer<ManagedDataFile<T>, Exception> loadFailed, @NotNull BiConsumer<ManagedDataFile<T>, Exception> saveFailed, @NotNull Consumer<ManagedDataFile<T>> beforeLoad, @NotNull Consumer<ManagedDataFile<T>> afterLoad, @NotNull Consumer<ManagedDataFile<T>> beforeSave, @NotNull Consumer<ManagedDataFile<T>> afterSave) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(loadFailed, (String)"loadFailed");
        Intrinsics.checkNotNullParameter(saveFailed, (String)"saveFailed");
        Intrinsics.checkNotNullParameter(beforeLoad, (String)"beforeLoad");
        Intrinsics.checkNotNullParameter(afterLoad, (String)"afterLoad");
        Intrinsics.checkNotNullParameter(beforeSave, (String)"beforeSave");
        Intrinsics.checkNotNullParameter(afterSave, (String)"afterSave");
        this.file = file;
        this.mapper = mapper;
        this.loadFailed = loadFailed;
        this.saveFailed = saveFailed;
        this.beforeLoad = beforeLoad;
        this.afterLoad = afterLoad;
        this.beforeSave = beforeSave;
        this.afterSave = afterSave;
        this.instance = this.mapper.createDefault();
        this.file.getParentFile().mkdirs();
        this.reloadFromFile();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final DataMapper<T> getMapper() {
        return this.mapper;
    }

    public ManagedDataFile(@NotNull ManagedDataFileBuilder<T> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this(builder.getFile(), builder.getMapper(), builder.getLoadFailed(), builder.getSaveFailed(), builder.getBeforeLoad(), builder.getAfterLoad(), builder.getBeforeSave(), builder.getAfterSave());
    }

    public final T getInstance() {
        return this.instance;
    }

    public final void setInstance(T t) {
        this.instance = t;
    }

    public final void reloadFromFile() {
        this.beforeLoad.accept(this);
        try {
            this.instance = this.file.exists() ? this.mapper.deserialize(FilesKt.readText$default((File)this.file, null, (int)1, null)) : this.mapper.createDefault();
        }
        catch (Exception ex) {
            this.loadFailed.accept(this, ex);
        }
        this.afterLoad.accept(this);
    }

    private final File createUniqueExtraFile(String identifier, File directory) {
        int jvmHash = ManagementFactory.getRuntimeMXBean().getName().hashCode();
        String timestamp = String.valueOf(System.currentTimeMillis());
        directory.mkdirs();
        return FilesKt.resolve((File)directory, (String)(FilesKt.getNameWithoutExtension((File)this.file) + '-' + jvmHash + '-' + timestamp + '-' + identifier + '.' + FilesKt.getExtension((File)this.file)));
    }

    static /* synthetic */ File createUniqueExtraFile$default(ManagedDataFile managedDataFile, String string, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createUniqueExtraFile");
        }
        if ((n & 2) != 0) {
            File file2 = managedDataFile.file.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.parentFile");
            file = file2;
        }
        return managedDataFile.createUniqueExtraFile(string, file);
    }

    public final void saveToFile() {
        this.beforeSave.accept(this);
        String toSave = this.mapper.serialize(this.instance);
        File temporarySaveFile = ManagedDataFile.createUniqueExtraFile$default(this, "save", null, 2, null);
        try {
            FilesKt.writeText$default((File)temporarySaveFile, (String)toSave, null, (int)2, null);
            this.mapper.deserialize(FilesKt.readText$default((File)temporarySaveFile, null, (int)1, null));
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(temporarySaveFile.toPath(), this.file.toPath(), copyOptionArray);
        }
        catch (Exception ex) {
            this.saveFailed.accept(this, ex);
        }
        this.afterSave.accept(this);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> ManagedDataFile<T> create(@NotNull File file, @NotNull Class<T> clazz, @NotNull Function1<? super ManagedDataFileBuilder<T>, Unit> consumer) {
        return Companion.create(file, clazz, consumer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> ManagedDataFile<T> create(@NotNull File file, @NotNull Class<T> clazz) {
        return Companion.create(file, clazz);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010JR\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\f\"\u0004\b\u0001\u0010\u00022\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u001f\b\u0002\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lmoe/nea/velox/moulconfig/managed/ManagedDataFile$Companion;", "", "T", "Ljava/io/File;", "file", "Ljava/lang/Class;", "clazz", "Lkotlin/Function1;", "Lmoe/nea/velox/moulconfig/managed/ManagedDataFileBuilder;", "", "Lkotlin/ExtensionFunctionType;", "consumer", "Lmoe/nea/velox/moulconfig/managed/ManagedDataFile;", "create", "(Ljava/io/File;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lio/github/notenoughupdates/moulconfig/managed/ManagedDataFile;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T> ManagedDataFile<T> create(@NotNull File file, @NotNull Class<T> clazz, @NotNull Function1<? super ManagedDataFileBuilder<T>, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            ManagedDataFileBuilder<T> managedDataFileBuilder = new ManagedDataFileBuilder<T>(file, clazz);
            consumer.invoke(managedDataFileBuilder);
            return new ManagedDataFile<T>(managedDataFileBuilder);
        }

        public static /* synthetic */ ManagedDataFile create$default(Companion companion, File file, Class clazz, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = create.1.INSTANCE;
            }
            return companion.create(file, clazz, function1);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T> ManagedDataFile<T> create(@NotNull File file, @NotNull Class<T> clazz) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return moe.nea.velox.moulconfig.managed.ManagedDataFile$Companion.create$default(this, file, clazz, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

