/*
 * Decompiled with CFR 0.152.
 */
package moe.nea.velox.moulconfig.observer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.nea.velox.moulconfig.internal.Warnings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GetSetter<T>
extends Supplier<T>,
Consumer<T> {
    @Override
    public T get();

    public void set(T var1);

    @Override
    default public void accept(T t) {
        this.set(t);
    }

    public static <T> GetSetter<T> constant(final T t) {
        return new GetSetter<T>(){

            @Override
            public T get() {
                return t;
            }

            @Override
            public void set(T newValue) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> GetSetter<T> floating(final T t) {
        return new GetSetter<T>(){
            T storage;
            {
                this.storage = t;
            }

            @Override
            public T get() {
                return this.storage;
            }

            @Override
            public void set(T newValue) {
                this.storage = newValue;
            }
        };
    }

    public static GetSetter<?> ofField(@Nullable Object owner, @NotNull Field field) {
        field.setAccessible(true);
        if (owner == null != Modifier.isStatic(field.getModifiers())) {
            Warnings.warn("Field instance (" + owner + ") is mismatched with field " + field);
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodHandle getter = lookup.unreflectGetter(field);
        MethodHandle setter = lookup.unreflectSetter(field);
        if (owner != null) {
            getter = getter.bindTo(owner);
            setter = setter.bindTo(owner);
        }
        final MethodHandle finalGetter = getter;
        final MethodHandle finalSetter = setter;
        return new GetSetter<Object>(){

            @Override
            public Object get() {
                return finalGetter.invoke();
            }

            @Override
            public void set(Object newValue) {
                finalSetter.invoke(newValue);
            }
        };
    }
}

