/*
 * Decompiled with CFR 0.152.
 */
package me.nixuge.epiczoomer.zoom;

import me.nixuge.epiczoomer.McMod;
import me.nixuge.epiczoomer.config.ConfigCache;

public class ZoomObject {
    private static float TANH_STARTING_VALUE_OFFSET = 2.0f;
    private static float TANH_ENDING_VALUE = TANH_STARTING_VALUE_OFFSET + 2.5f;
    private static ConfigCache configCache = McMod.getInstance().getConfigCache();
    private double startPercent;
    private long startTime = System.currentTimeMillis();
    private int targetZoomPercent;
    private double zoomPercentDifferenceStartFinish;
    private float animationTime;
    private boolean instaZoom = false;
    private final boolean isSmoothCamera;

    public ZoomObject(int startPercent, int targetPercent) {
        this.startPercent = startPercent;
        this.zoomPercentDifferenceStartFinish = 99.0;
        this.targetZoomPercent = targetPercent;
        this.animationTime = this.getAnimationTotalTime(99.0);
        this.instaZoom = this.animationTime < 15.0f || configCache.getMsForHundredPercentZoom() < 15;
        this.isSmoothCamera = configCache.isSmoothCamera();
    }

    public void updateTargetPercent(int newTargetPercent) {
        this.startPercent = this.getPercentageToSet();
        this.startTime = System.currentTimeMillis();
        this.zoomPercentDifferenceStartFinish = (double)newTargetPercent - this.startPercent;
        this.animationTime = this.getAnimationTotalTime(Math.abs(this.zoomPercentDifferenceStartFinish));
        this.targetZoomPercent = newTargetPercent;
        this.instaZoom = this.animationTime < 15.0f;
    }

    private float getAnimationTotalTime(double percentChange) {
        int msHundred = configCache.getMsForHundredPercentZoom();
        if (msHundred < 16) {
            msHundred = 15;
        }
        if (configCache.isAdaptativeZoomTime()) {
            int animTime = (int)(percentChange / 100.0 * (double)msHundred);
            if (animTime > configCache.getMaxZoomTime()) {
                return configCache.getMaxZoomTime();
            }
            return animTime;
        }
        return msHundred;
    }

    public boolean hasAnimationEnded() {
        return (float)this.getAnimationTimeProgress() > this.animationTime && Math.abs((double)this.targetZoomPercent - this.getPercentageToSet()) < 0.01;
    }

    public long getAnimationTimeProgress() {
        return System.currentTimeMillis() - this.startTime;
    }

    public double getCurrentProgressPercent() {
        return (Math.tanh((float)this.getAnimationTimeProgress() / this.animationTime * TANH_ENDING_VALUE - TANH_STARTING_VALUE_OFFSET) + 1.0) / 2.0;
    }

    public double getPercentageToSet() {
        if (this.instaZoom) {
            return this.targetZoomPercent;
        }
        double percentage = this.startPercent + this.getCurrentProgressPercent() * this.zoomPercentDifferenceStartFinish;
        if (percentage < 2.0) {
            return 1.0;
        }
        return percentage;
    }

    public int getTargetZoomPercent() {
        return this.targetZoomPercent;
    }

    public boolean isSmoothCamera() {
        return this.isSmoothCamera;
    }
}

